/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InsightCategory {
    FAULT("FAULT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InsightCategory> VALUE_MAP;
    private final String value;

    private InsightCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InsightCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InsightCategory> knownValues() {
        EnumSet<InsightCategory> knownValues = EnumSet.allOf(InsightCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InsightCategory.class, InsightCategory::toString);
    }
}

