/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestImpactStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestImpactStatistics> {
    private static final SdkField<Long> FAULT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FaultCount").getter(RequestImpactStatistics.getter(RequestImpactStatistics::faultCount)).setter(RequestImpactStatistics.setter(Builder::faultCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCount").build()}).build();
    private static final SdkField<Long> OK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("OkCount").getter(RequestImpactStatistics.getter(RequestImpactStatistics::okCount)).setter(RequestImpactStatistics.setter(Builder::okCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OkCount").build()}).build();
    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalCount").getter(RequestImpactStatistics.getter(RequestImpactStatistics::totalCount)).setter(RequestImpactStatistics.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAULT_COUNT_FIELD, OK_COUNT_FIELD, TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FaultCount", FAULT_COUNT_FIELD);
            this.put("OkCount", OK_COUNT_FIELD);
            this.put("TotalCount", TOTAL_COUNT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long faultCount;
    private final Long okCount;
    private final Long totalCount;

    private RequestImpactStatistics(BuilderImpl builder) {
        this.faultCount = builder.faultCount;
        this.okCount = builder.okCount;
        this.totalCount = builder.totalCount;
    }

    public final Long faultCount() {
        return this.faultCount;
    }

    public final Long okCount() {
        return this.okCount;
    }

    public final Long totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.faultCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.okCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestImpactStatistics)) {
            return false;
        }
        RequestImpactStatistics other = (RequestImpactStatistics)obj;
        return Objects.equals(this.faultCount(), other.faultCount()) && Objects.equals(this.okCount(), other.okCount()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public final String toString() {
        return ToString.builder((String)"RequestImpactStatistics").add("FaultCount", (Object)this.faultCount()).add("OkCount", (Object)this.okCount()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaultCount": {
                return Optional.ofNullable(clazz.cast(this.faultCount()));
            }
            case "OkCount": {
                return Optional.ofNullable(clazz.cast(this.okCount()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RequestImpactStatistics, T> g) {
        return obj -> g.apply((RequestImpactStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long faultCount;
        private Long okCount;
        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestImpactStatistics model) {
            this.faultCount(model.faultCount);
            this.okCount(model.okCount);
            this.totalCount(model.totalCount);
        }

        public final Long getFaultCount() {
            return this.faultCount;
        }

        public final void setFaultCount(Long faultCount) {
            this.faultCount = faultCount;
        }

        @Override
        public final Builder faultCount(Long faultCount) {
            this.faultCount = faultCount;
            return this;
        }

        public final Long getOkCount() {
            return this.okCount;
        }

        public final void setOkCount(Long okCount) {
            this.okCount = okCount;
        }

        @Override
        public final Builder okCount(Long okCount) {
            this.okCount = okCount;
            return this;
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public RequestImpactStatistics build() {
            return new RequestImpactStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestImpactStatistics> {
        public Builder faultCount(Long var1);

        public Builder okCount(Long var1);

        public Builder totalCount(Long var1);
    }
}

