/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.ResourcePolicy;
import software.amazon.awssdk.services.xray.model.ResourcePolicyListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourcePoliciesResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, ListResourcePoliciesResponse> {
    private static final SdkField<List<ResourcePolicy>> RESOURCE_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourcePolicies").getter(ListResourcePoliciesResponse.getter(ListResourcePoliciesResponse::resourcePolicies)).setter(ListResourcePoliciesResponse.setter(Builder::resourcePolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourcePoliciesResponse.getter(ListResourcePoliciesResponse::nextToken)).setter(ListResourcePoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_POLICIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourcePolicies", RESOURCE_POLICIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ResourcePolicy> resourcePolicies;
    private final String nextToken;

    private ListResourcePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.resourcePolicies = builder.resourcePolicies;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourcePolicies() {
        return this.resourcePolicies != null && !(this.resourcePolicies instanceof SdkAutoConstructList);
    }

    public final List<ResourcePolicy> resourcePolicies() {
        return this.resourcePolicies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcePolicies() ? this.resourcePolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcePoliciesResponse)) {
            return false;
        }
        ListResourcePoliciesResponse other = (ListResourcePoliciesResponse)((Object)obj);
        return this.hasResourcePolicies() == other.hasResourcePolicies() && Objects.equals(this.resourcePolicies(), other.resourcePolicies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourcePoliciesResponse").add("ResourcePolicies", this.hasResourcePolicies() ? this.resourcePolicies() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourcePolicies": {
                return Optional.ofNullable(clazz.cast(this.resourcePolicies()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcePoliciesResponse, T> g) {
        return obj -> g.apply((ListResourcePoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<ResourcePolicy> resourcePolicies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcePoliciesResponse model) {
            super(model);
            this.resourcePolicies(model.resourcePolicies);
            this.nextToken(model.nextToken);
        }

        public final List<ResourcePolicy.Builder> getResourcePolicies() {
            List<ResourcePolicy.Builder> result = ResourcePolicyListCopier.copyToBuilder(this.resourcePolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcePolicies(Collection<ResourcePolicy.BuilderImpl> resourcePolicies) {
            this.resourcePolicies = ResourcePolicyListCopier.copyFromBuilder(resourcePolicies);
        }

        @Override
        public final Builder resourcePolicies(Collection<ResourcePolicy> resourcePolicies) {
            this.resourcePolicies = ResourcePolicyListCopier.copy(resourcePolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePolicies(ResourcePolicy ... resourcePolicies) {
            this.resourcePolicies(Arrays.asList(resourcePolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePolicies(Consumer<ResourcePolicy.Builder> ... resourcePolicies) {
            this.resourcePolicies(Stream.of(resourcePolicies).map(c -> (ResourcePolicy)((ResourcePolicy.Builder)ResourcePolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourcePoliciesResponse build() {
            return new ListResourcePoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourcePoliciesResponse> {
        public Builder resourcePolicies(Collection<ResourcePolicy> var1);

        public Builder resourcePolicies(ResourcePolicy ... var1);

        public Builder resourcePolicies(Consumer<ResourcePolicy.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

