/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.TimeSeriesServiceStatistics;
import software.amazon.awssdk.services.xray.model.TimeSeriesServiceStatisticsListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTimeSeriesServiceStatisticsResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetTimeSeriesServiceStatisticsResponse> {
    private static final SdkField<List<TimeSeriesServiceStatistics>> TIME_SERIES_SERVICE_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimeSeriesServiceStatistics").getter(GetTimeSeriesServiceStatisticsResponse.getter(GetTimeSeriesServiceStatisticsResponse::timeSeriesServiceStatistics)).setter(GetTimeSeriesServiceStatisticsResponse.setter(Builder::timeSeriesServiceStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesServiceStatistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeriesServiceStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CONTAINS_OLD_GROUP_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ContainsOldGroupVersions").getter(GetTimeSeriesServiceStatisticsResponse.getter(GetTimeSeriesServiceStatisticsResponse::containsOldGroupVersions)).setter(GetTimeSeriesServiceStatisticsResponse.setter(Builder::containsOldGroupVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsOldGroupVersions").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTimeSeriesServiceStatisticsResponse.getter(GetTimeSeriesServiceStatisticsResponse::nextToken)).setter(GetTimeSeriesServiceStatisticsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_SERIES_SERVICE_STATISTICS_FIELD, CONTAINS_OLD_GROUP_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TimeSeriesServiceStatistics", TIME_SERIES_SERVICE_STATISTICS_FIELD);
            this.put("ContainsOldGroupVersions", CONTAINS_OLD_GROUP_VERSIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<TimeSeriesServiceStatistics> timeSeriesServiceStatistics;
    private final Boolean containsOldGroupVersions;
    private final String nextToken;

    private GetTimeSeriesServiceStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.timeSeriesServiceStatistics = builder.timeSeriesServiceStatistics;
        this.containsOldGroupVersions = builder.containsOldGroupVersions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTimeSeriesServiceStatistics() {
        return this.timeSeriesServiceStatistics != null && !(this.timeSeriesServiceStatistics instanceof SdkAutoConstructList);
    }

    public final List<TimeSeriesServiceStatistics> timeSeriesServiceStatistics() {
        return this.timeSeriesServiceStatistics;
    }

    public final Boolean containsOldGroupVersions() {
        return this.containsOldGroupVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimeSeriesServiceStatistics() ? this.timeSeriesServiceStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.containsOldGroupVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTimeSeriesServiceStatisticsResponse)) {
            return false;
        }
        GetTimeSeriesServiceStatisticsResponse other = (GetTimeSeriesServiceStatisticsResponse)((Object)obj);
        return this.hasTimeSeriesServiceStatistics() == other.hasTimeSeriesServiceStatistics() && Objects.equals(this.timeSeriesServiceStatistics(), other.timeSeriesServiceStatistics()) && Objects.equals(this.containsOldGroupVersions(), other.containsOldGroupVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTimeSeriesServiceStatisticsResponse").add("TimeSeriesServiceStatistics", this.hasTimeSeriesServiceStatistics() ? this.timeSeriesServiceStatistics() : null).add("ContainsOldGroupVersions", (Object)this.containsOldGroupVersions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeSeriesServiceStatistics": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesServiceStatistics()));
            }
            case "ContainsOldGroupVersions": {
                return Optional.ofNullable(clazz.cast(this.containsOldGroupVersions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTimeSeriesServiceStatisticsResponse, T> g) {
        return obj -> g.apply((GetTimeSeriesServiceStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<TimeSeriesServiceStatistics> timeSeriesServiceStatistics = DefaultSdkAutoConstructList.getInstance();
        private Boolean containsOldGroupVersions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTimeSeriesServiceStatisticsResponse model) {
            super(model);
            this.timeSeriesServiceStatistics(model.timeSeriesServiceStatistics);
            this.containsOldGroupVersions(model.containsOldGroupVersions);
            this.nextToken(model.nextToken);
        }

        public final List<TimeSeriesServiceStatistics.Builder> getTimeSeriesServiceStatistics() {
            List<TimeSeriesServiceStatistics.Builder> result = TimeSeriesServiceStatisticsListCopier.copyToBuilder(this.timeSeriesServiceStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesServiceStatistics(Collection<TimeSeriesServiceStatistics.BuilderImpl> timeSeriesServiceStatistics) {
            this.timeSeriesServiceStatistics = TimeSeriesServiceStatisticsListCopier.copyFromBuilder(timeSeriesServiceStatistics);
        }

        @Override
        public final Builder timeSeriesServiceStatistics(Collection<TimeSeriesServiceStatistics> timeSeriesServiceStatistics) {
            this.timeSeriesServiceStatistics = TimeSeriesServiceStatisticsListCopier.copy(timeSeriesServiceStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesServiceStatistics(TimeSeriesServiceStatistics ... timeSeriesServiceStatistics) {
            this.timeSeriesServiceStatistics(Arrays.asList(timeSeriesServiceStatistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesServiceStatistics(Consumer<TimeSeriesServiceStatistics.Builder> ... timeSeriesServiceStatistics) {
            this.timeSeriesServiceStatistics(Stream.of(timeSeriesServiceStatistics).map(c -> (TimeSeriesServiceStatistics)((TimeSeriesServiceStatistics.Builder)TimeSeriesServiceStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getContainsOldGroupVersions() {
            return this.containsOldGroupVersions;
        }

        public final void setContainsOldGroupVersions(Boolean containsOldGroupVersions) {
            this.containsOldGroupVersions = containsOldGroupVersions;
        }

        @Override
        public final Builder containsOldGroupVersions(Boolean containsOldGroupVersions) {
            this.containsOldGroupVersions = containsOldGroupVersions;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTimeSeriesServiceStatisticsResponse build() {
            return new GetTimeSeriesServiceStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTimeSeriesServiceStatisticsResponse> {
        public Builder timeSeriesServiceStatistics(Collection<TimeSeriesServiceStatistics> var1);

        public Builder timeSeriesServiceStatistics(TimeSeriesServiceStatistics ... var1);

        public Builder timeSeriesServiceStatistics(Consumer<TimeSeriesServiceStatistics.Builder> ... var1);

        public Builder containsOldGroupVersions(Boolean var1);

        public Builder nextToken(String var1);
    }
}

