/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.IndexingRule;
import software.amazon.awssdk.services.xray.model.IndexingRuleListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIndexingRulesResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetIndexingRulesResponse> {
    private static final SdkField<List<IndexingRule>> INDEXING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IndexingRules").getter(GetIndexingRulesResponse.getter(GetIndexingRulesResponse::indexingRules)).setter(GetIndexingRulesResponse.setter(Builder::indexingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IndexingRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIndexingRulesResponse.getter(GetIndexingRulesResponse::nextToken)).setter(GetIndexingRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEXING_RULES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IndexingRules", INDEXING_RULES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<IndexingRule> indexingRules;
    private final String nextToken;

    private GetIndexingRulesResponse(BuilderImpl builder) {
        super(builder);
        this.indexingRules = builder.indexingRules;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIndexingRules() {
        return this.indexingRules != null && !(this.indexingRules instanceof SdkAutoConstructList);
    }

    public final List<IndexingRule> indexingRules() {
        return this.indexingRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIndexingRules() ? this.indexingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIndexingRulesResponse)) {
            return false;
        }
        GetIndexingRulesResponse other = (GetIndexingRulesResponse)((Object)obj);
        return this.hasIndexingRules() == other.hasIndexingRules() && Objects.equals(this.indexingRules(), other.indexingRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetIndexingRulesResponse").add("IndexingRules", this.hasIndexingRules() ? this.indexingRules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexingRules": {
                return Optional.ofNullable(clazz.cast(this.indexingRules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetIndexingRulesResponse, T> g) {
        return obj -> g.apply((GetIndexingRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<IndexingRule> indexingRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIndexingRulesResponse model) {
            super(model);
            this.indexingRules(model.indexingRules);
            this.nextToken(model.nextToken);
        }

        public final List<IndexingRule.Builder> getIndexingRules() {
            List<IndexingRule.Builder> result = IndexingRuleListCopier.copyToBuilder(this.indexingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexingRules(Collection<IndexingRule.BuilderImpl> indexingRules) {
            this.indexingRules = IndexingRuleListCopier.copyFromBuilder(indexingRules);
        }

        @Override
        public final Builder indexingRules(Collection<IndexingRule> indexingRules) {
            this.indexingRules = IndexingRuleListCopier.copy(indexingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexingRules(IndexingRule ... indexingRules) {
            this.indexingRules(Arrays.asList(indexingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexingRules(Consumer<IndexingRule.Builder> ... indexingRules) {
            this.indexingRules(Stream.of(indexingRules).map(c -> (IndexingRule)((IndexingRule.Builder)IndexingRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIndexingRulesResponse build() {
            return new GetIndexingRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIndexingRulesResponse> {
        public Builder indexingRules(Collection<IndexingRule> var1);

        public Builder indexingRules(IndexingRule ... var1);

        public Builder indexingRules(Consumer<IndexingRule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

