/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.internal.UserAgentUtils;
import software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse;
import software.amazon.awssdk.services.xray.model.SamplingStatisticSummary;

public class GetSamplingStatisticSummariesIterable
implements SdkIterable<GetSamplingStatisticSummariesResponse> {
    private final XRayClient client;
    private final GetSamplingStatisticSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSamplingStatisticSummariesIterable(XRayClient client, GetSamplingStatisticSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetSamplingStatisticSummariesResponseFetcher();
    }

    public Iterator<GetSamplingStatisticSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SamplingStatisticSummary> samplingStatisticSummaries() {
        Function<GetSamplingStatisticSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.samplingStatisticSummaries() != null) {
                return response.samplingStatisticSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetSamplingStatisticSummariesResponseFetcher
    implements SyncPageFetcher<GetSamplingStatisticSummariesResponse> {
        private GetSamplingStatisticSummariesResponseFetcher() {
        }

        public boolean hasNextPage(GetSamplingStatisticSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSamplingStatisticSummariesResponse nextPage(GetSamplingStatisticSummariesResponse previousPage) {
            if (previousPage == null) {
                return GetSamplingStatisticSummariesIterable.this.client.getSamplingStatisticSummaries(GetSamplingStatisticSummariesIterable.this.firstRequest);
            }
            return GetSamplingStatisticSummariesIterable.this.client.getSamplingStatisticSummaries((GetSamplingStatisticSummariesRequest)((Object)GetSamplingStatisticSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

