/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.internal.UserAgentUtils;
import software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest;
import software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsResponse;
import software.amazon.awssdk.services.xray.model.TimeSeriesServiceStatistics;

public class GetTimeSeriesServiceStatisticsIterable
implements SdkIterable<GetTimeSeriesServiceStatisticsResponse> {
    private final XRayClient client;
    private final GetTimeSeriesServiceStatisticsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTimeSeriesServiceStatisticsIterable(XRayClient client, GetTimeSeriesServiceStatisticsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetTimeSeriesServiceStatisticsResponseFetcher();
    }

    public Iterator<GetTimeSeriesServiceStatisticsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TimeSeriesServiceStatistics> timeSeriesServiceStatistics() {
        Function<GetTimeSeriesServiceStatisticsResponse, Iterator> getIterator = response -> {
            if (response != null && response.timeSeriesServiceStatistics() != null) {
                return response.timeSeriesServiceStatistics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetTimeSeriesServiceStatisticsResponseFetcher
    implements SyncPageFetcher<GetTimeSeriesServiceStatisticsResponse> {
        private GetTimeSeriesServiceStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(GetTimeSeriesServiceStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetTimeSeriesServiceStatisticsResponse nextPage(GetTimeSeriesServiceStatisticsResponse previousPage) {
            if (previousPage == null) {
                return GetTimeSeriesServiceStatisticsIterable.this.client.getTimeSeriesServiceStatistics(GetTimeSeriesServiceStatisticsIterable.this.firstRequest);
            }
            return GetTimeSeriesServiceStatisticsIterable.this.client.getTimeSeriesServiceStatistics((GetTimeSeriesServiceStatisticsRequest)((Object)GetTimeSeriesServiceStatisticsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

