/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.internal.UserAgentUtils;
import software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse;
import software.amazon.awssdk.services.xray.model.SamplingRuleRecord;

public class GetSamplingRulesIterable
implements SdkIterable<GetSamplingRulesResponse> {
    private final XRayClient client;
    private final GetSamplingRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSamplingRulesIterable(XRayClient client, GetSamplingRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetSamplingRulesResponseFetcher();
    }

    public Iterator<GetSamplingRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SamplingRuleRecord> samplingRuleRecords() {
        Function<GetSamplingRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.samplingRuleRecords() != null) {
                return response.samplingRuleRecords().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetSamplingRulesResponseFetcher
    implements SyncPageFetcher<GetSamplingRulesResponse> {
        private GetSamplingRulesResponseFetcher() {
        }

        public boolean hasNextPage(GetSamplingRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSamplingRulesResponse nextPage(GetSamplingRulesResponse previousPage) {
            if (previousPage == null) {
                return GetSamplingRulesIterable.this.client.getSamplingRules(GetSamplingRulesIterable.this.firstRequest);
            }
            return GetSamplingRulesIterable.this.client.getSamplingRules((GetSamplingRulesRequest)((Object)GetSamplingRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

