/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.xray.DefaultXRayBaseClientBuilder;
import software.amazon.awssdk.services.xray.DefaultXRayClient;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.XRayClientBuilder;
import software.amazon.awssdk.services.xray.XRayServiceClientConfiguration;
import software.amazon.awssdk.services.xray.endpoints.XRayEndpointProvider;

@SdkInternalApi
final class DefaultXRayClientBuilder
extends DefaultXRayBaseClientBuilder<XRayClientBuilder, XRayClient>
implements XRayClientBuilder {
    DefaultXRayClientBuilder() {
    }

    @Override
    public DefaultXRayClientBuilder endpointProvider(XRayEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final XRayClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultXRayClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        XRayServiceClientConfiguration serviceClientConfiguration = XRayServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultXRayClient(serviceClientConfiguration, clientConfiguration);
    }
}

