/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.xray.DefaultXRayAsyncClient;
import software.amazon.awssdk.services.xray.DefaultXRayBaseClientBuilder;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.XRayAsyncClientBuilder;
import software.amazon.awssdk.services.xray.XRayServiceClientConfiguration;
import software.amazon.awssdk.services.xray.endpoints.XRayEndpointProvider;

@SdkInternalApi
final class DefaultXRayAsyncClientBuilder
extends DefaultXRayBaseClientBuilder<XRayAsyncClientBuilder, XRayAsyncClient>
implements XRayAsyncClientBuilder {
    DefaultXRayAsyncClientBuilder() {
    }

    @Override
    public DefaultXRayAsyncClientBuilder endpointProvider(XRayEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final XRayAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultXRayAsyncClientBuilder.validateClientOptions(clientConfiguration);
        XRayServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultXRayAsyncClient client = new DefaultXRayAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private XRayServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return XRayServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

