/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InsightState {
    ACTIVE("ACTIVE"),
    CLOSED("CLOSED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InsightState> VALUE_MAP;
    private final String value;

    private InsightState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InsightState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InsightState> knownValues() {
        EnumSet<InsightState> knownValues = EnumSet.allOf(InsightState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InsightState.class, InsightState::toString);
    }
}

