/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.Service;
import software.amazon.awssdk.services.xray.model.ServiceListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTraceGraphResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetTraceGraphResponse> {
    private static final SdkField<List<Service>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Services").getter(GetTraceGraphResponse.getter(GetTraceGraphResponse::services)).setter(GetTraceGraphResponse.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Service::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTraceGraphResponse.getter(GetTraceGraphResponse::nextToken)).setter(GetTraceGraphResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Service> services;
    private final String nextToken;

    private GetTraceGraphResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<Service> services() {
        return this.services;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceGraphResponse)) {
            return false;
        }
        GetTraceGraphResponse other = (GetTraceGraphResponse)((Object)obj);
        return this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTraceGraphResponse").add("Services", this.hasServices() ? this.services() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTraceGraphResponse, T> g) {
        return obj -> g.apply((GetTraceGraphResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<Service> services = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceGraphResponse model) {
            super(model);
            this.services(model.services);
            this.nextToken(model.nextToken);
        }

        public final List<Service.Builder> getServices() {
            List<Service.Builder> result = ServiceListCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<Service.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (Service)((Service.Builder)Service.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<Service.BuilderImpl> services) {
            this.services = ServiceListCopier.copyFromBuilder(services);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTraceGraphResponse build() {
            return new GetTraceGraphResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTraceGraphResponse> {
        public Builder services(Collection<Service> var1);

        public Builder services(Service ... var1);

        public Builder services(Consumer<Service.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

