/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InsightState {
    ACTIVE("ACTIVE"),
    CLOSED("CLOSED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InsightState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InsightState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InsightState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InsightState> knownValues() {
        return Stream.of(InsightState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

