/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.InsightImpactGraphEdge;
import software.amazon.awssdk.services.xray.model.InsightImpactGraphEdgeListCopier;
import software.amazon.awssdk.services.xray.model.ServiceNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightImpactGraphService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightImpactGraphService> {
    private static final SdkField<Integer> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReferenceId").getter(InsightImpactGraphService.getter(InsightImpactGraphService::referenceId)).setter(InsightImpactGraphService.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(InsightImpactGraphService.getter(InsightImpactGraphService::type)).setter(InsightImpactGraphService.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InsightImpactGraphService.getter(InsightImpactGraphService::name)).setter(InsightImpactGraphService.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(InsightImpactGraphService.getter(InsightImpactGraphService::names)).setter(InsightImpactGraphService.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(InsightImpactGraphService.getter(InsightImpactGraphService::accountId)).setter(InsightImpactGraphService.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<List<InsightImpactGraphEdge>> EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Edges").getter(InsightImpactGraphService.getter(InsightImpactGraphService::edges)).setter(InsightImpactGraphService.setter(Builder::edges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightImpactGraphEdge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD, TYPE_FIELD, NAME_FIELD, NAMES_FIELD, ACCOUNT_ID_FIELD, EDGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer referenceId;
    private final String type;
    private final String name;
    private final List<String> names;
    private final String accountId;
    private final List<InsightImpactGraphEdge> edges;

    private InsightImpactGraphService(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.type = builder.type;
        this.name = builder.name;
        this.names = builder.names;
        this.accountId = builder.accountId;
        this.edges = builder.edges;
    }

    public final Integer referenceId() {
        return this.referenceId;
    }

    public final String type() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<String> names() {
        return this.names;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasEdges() {
        return this.edges != null && !(this.edges instanceof SdkAutoConstructList);
    }

    public final List<InsightImpactGraphEdge> edges() {
        return this.edges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdges() ? this.edges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightImpactGraphService)) {
            return false;
        }
        InsightImpactGraphService other = (InsightImpactGraphService)obj;
        return Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.name(), other.name()) && this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && Objects.equals(this.accountId(), other.accountId()) && this.hasEdges() == other.hasEdges() && Objects.equals(this.edges(), other.edges());
    }

    public final String toString() {
        return ToString.builder((String)"InsightImpactGraphService").add("ReferenceId", (Object)this.referenceId()).add("Type", (Object)this.type()).add("Name", (Object)this.name()).add("Names", this.hasNames() ? this.names() : null).add("AccountId", (Object)this.accountId()).add("Edges", this.hasEdges() ? this.edges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Edges": {
                return Optional.ofNullable(clazz.cast(this.edges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightImpactGraphService, T> g) {
        return obj -> g.apply((InsightImpactGraphService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer referenceId;
        private String type;
        private String name;
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private String accountId;
        private List<InsightImpactGraphEdge> edges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InsightImpactGraphService model) {
            this.referenceId(model.referenceId);
            this.type(model.type);
            this.name(model.name);
            this.names(model.names);
            this.accountId(model.accountId);
            this.edges(model.edges);
        }

        public final Integer getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(Integer referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(Integer referenceId) {
            this.referenceId = referenceId;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getNames() {
            if (this.names instanceof SdkAutoConstructList) {
                return null;
            }
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Collection<InsightImpactGraphEdge.Builder> getEdges() {
            if (this.edges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.edges != null ? (Collection)this.edges.stream().map(InsightImpactGraphEdge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder edges(Collection<InsightImpactGraphEdge> edges) {
            this.edges = InsightImpactGraphEdgeListCopier.copy(edges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(InsightImpactGraphEdge ... edges) {
            this.edges(Arrays.asList(edges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Consumer<InsightImpactGraphEdge.Builder> ... edges) {
            this.edges(Stream.of(edges).map(c -> (InsightImpactGraphEdge)((InsightImpactGraphEdge.Builder)InsightImpactGraphEdge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEdges(Collection<InsightImpactGraphEdge.BuilderImpl> edges) {
            this.edges = InsightImpactGraphEdgeListCopier.copyFromBuilder(edges);
        }

        public InsightImpactGraphService build() {
            return new InsightImpactGraphService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightImpactGraphService> {
        public Builder referenceId(Integer var1);

        public Builder type(String var1);

        public Builder name(String var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder accountId(String var1);

        public Builder edges(Collection<InsightImpactGraphEdge> var1);

        public Builder edges(InsightImpactGraphEdge ... var1);

        public Builder edges(Consumer<InsightImpactGraphEdge.Builder> ... var1);
    }
}

