/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.FaultRootCauseEntity;
import software.amazon.awssdk.services.xray.model.FaultRootCauseEntityPathCopier;
import software.amazon.awssdk.services.xray.model.ServiceNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FaultRootCauseService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FaultRootCauseService> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FaultRootCauseService.getter(FaultRootCauseService::name)).setter(FaultRootCauseService.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(FaultRootCauseService.getter(FaultRootCauseService::names)).setter(FaultRootCauseService.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(FaultRootCauseService.getter(FaultRootCauseService::type)).setter(FaultRootCauseService.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(FaultRootCauseService.getter(FaultRootCauseService::accountId)).setter(FaultRootCauseService.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<List<FaultRootCauseEntity>> ENTITY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityPath").getter(FaultRootCauseService.getter(FaultRootCauseService::entityPath)).setter(FaultRootCauseService.setter(Builder::entityPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FaultRootCauseEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Inferred").getter(FaultRootCauseService.getter(FaultRootCauseService::inferred)).setter(FaultRootCauseService.setter(Builder::inferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inferred").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NAMES_FIELD, TYPE_FIELD, ACCOUNT_ID_FIELD, ENTITY_PATH_FIELD, INFERRED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> names;
    private final String type;
    private final String accountId;
    private final List<FaultRootCauseEntity> entityPath;
    private final Boolean inferred;

    private FaultRootCauseService(BuilderImpl builder) {
        this.name = builder.name;
        this.names = builder.names;
        this.type = builder.type;
        this.accountId = builder.accountId;
        this.entityPath = builder.entityPath;
        this.inferred = builder.inferred;
    }

    public String name() {
        return this.name;
    }

    public boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public List<String> names() {
        return this.names;
    }

    public String type() {
        return this.type;
    }

    public String accountId() {
        return this.accountId;
    }

    public boolean hasEntityPath() {
        return this.entityPath != null && !(this.entityPath instanceof SdkAutoConstructList);
    }

    public List<FaultRootCauseEntity> entityPath() {
        return this.entityPath;
    }

    public Boolean inferred() {
        return this.inferred;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.names());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferred());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaultRootCauseService)) {
            return false;
        }
        FaultRootCauseService other = (FaultRootCauseService)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.names(), other.names()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.entityPath(), other.entityPath()) && Objects.equals(this.inferred(), other.inferred());
    }

    public String toString() {
        return ToString.builder((String)"FaultRootCauseService").add("Name", (Object)this.name()).add("Names", this.names()).add("Type", (Object)this.type()).add("AccountId", (Object)this.accountId()).add("EntityPath", this.entityPath()).add("Inferred", (Object)this.inferred()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "EntityPath": {
                return Optional.ofNullable(clazz.cast(this.entityPath()));
            }
            case "Inferred": {
                return Optional.ofNullable(clazz.cast(this.inferred()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FaultRootCauseService, T> g) {
        return obj -> g.apply((FaultRootCauseService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private String accountId;
        private List<FaultRootCauseEntity> entityPath = DefaultSdkAutoConstructList.getInstance();
        private Boolean inferred;

        private BuilderImpl() {
        }

        private BuilderImpl(FaultRootCauseService model) {
            this.name(model.name);
            this.names(model.names);
            this.type(model.type);
            this.accountId(model.accountId);
            this.entityPath(model.entityPath);
            this.inferred(model.inferred);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getNames() {
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Collection<FaultRootCauseEntity.Builder> getEntityPath() {
            return this.entityPath != null ? (Collection)this.entityPath.stream().map(FaultRootCauseEntity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entityPath(Collection<FaultRootCauseEntity> entityPath) {
            this.entityPath = FaultRootCauseEntityPathCopier.copy(entityPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityPath(FaultRootCauseEntity ... entityPath) {
            this.entityPath(Arrays.asList(entityPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityPath(Consumer<FaultRootCauseEntity.Builder> ... entityPath) {
            this.entityPath(Stream.of(entityPath).map(c -> (FaultRootCauseEntity)((FaultRootCauseEntity.Builder)FaultRootCauseEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntityPath(Collection<FaultRootCauseEntity.BuilderImpl> entityPath) {
            this.entityPath = FaultRootCauseEntityPathCopier.copyFromBuilder(entityPath);
        }

        public final Boolean getInferred() {
            return this.inferred;
        }

        @Override
        public final Builder inferred(Boolean inferred) {
            this.inferred = inferred;
            return this;
        }

        public final void setInferred(Boolean inferred) {
            this.inferred = inferred;
        }

        public FaultRootCauseService build() {
            return new FaultRootCauseService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FaultRootCauseService> {
        public Builder name(String var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder type(String var1);

        public Builder accountId(String var1);

        public Builder entityPath(Collection<FaultRootCauseEntity> var1);

        public Builder entityPath(FaultRootCauseEntity ... var1);

        public Builder entityPath(Consumer<FaultRootCauseEntity.Builder> ... var1);

        public Builder inferred(Boolean var1);
    }
}

