/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.ServiceId;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServiceIdMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> NAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Names").isBinary(false).build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final ServiceIdMarshaller INSTANCE = new ServiceIdMarshaller();

    private ServiceIdMarshaller() {
    }

    public static ServiceIdMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ServiceId serviceId, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)serviceId, (String)"serviceId");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)serviceId.name(), NAME_BINDING);
            protocolMarshaller.marshall(serviceId.names(), NAMES_BINDING);
            protocolMarshaller.marshall((Object)serviceId.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)serviceId.type(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

