/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.Http;

public class HttpUnmarshaller
implements Unmarshaller<Http, JsonUnmarshallerContext> {
    private static final HttpUnmarshaller INSTANCE = new HttpUnmarshaller();

    public Http unmarshall(JsonUnmarshallerContext context) throws Exception {
        Http.Builder httpBuilder = Http.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("HttpURL", targetDepth)) {
                    context.nextToken();
                    httpBuilder.httpURL((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HttpStatus", targetDepth)) {
                    context.nextToken();
                    httpBuilder.httpStatus((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("HttpMethod", targetDepth)) {
                    context.nextToken();
                    httpBuilder.httpMethod((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("UserAgent", targetDepth)) {
                    context.nextToken();
                    httpBuilder.userAgent((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ClientIp", targetDepth)) {
                    context.nextToken();
                    httpBuilder.clientIp((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Http)httpBuilder.build();
    }

    public static HttpUnmarshaller getInstance() {
        return INSTANCE;
    }
}

