/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.ErrorStatistics;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ErrorStatisticsMarshaller {
    private static final MarshallingInfo<Long> THROTTLECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThrottleCount").isBinary(false).build();
    private static final MarshallingInfo<Long> OTHERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OtherCount").isBinary(false).build();
    private static final MarshallingInfo<Long> TOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCount").isBinary(false).build();
    private static final ErrorStatisticsMarshaller INSTANCE = new ErrorStatisticsMarshaller();

    private ErrorStatisticsMarshaller() {
    }

    public static ErrorStatisticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ErrorStatistics errorStatistics, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)errorStatistics, (String)"errorStatistics");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)errorStatistics.throttleCount(), THROTTLECOUNT_BINDING);
            protocolMarshaller.marshall((Object)errorStatistics.otherCount(), OTHERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)errorStatistics.totalCount(), TOTALCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

