/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.AnnotationValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AnnotationValueMarshaller {
    private static final MarshallingInfo<Double> NUMBERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberValue").isBinary(false).build();
    private static final MarshallingInfo<Boolean> BOOLEANVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BooleanValue").isBinary(false).build();
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringValue").isBinary(false).build();
    private static final AnnotationValueMarshaller INSTANCE = new AnnotationValueMarshaller();

    private AnnotationValueMarshaller() {
    }

    public static AnnotationValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AnnotationValue annotationValue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)annotationValue, (String)"annotationValue");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)annotationValue.numberValue(), NUMBERVALUE_BINDING);
            protocolMarshaller.marshall((Object)annotationValue.booleanValue(), BOOLEANVALUE_BINDING);
            protocolMarshaller.marshall((Object)annotationValue.stringValue(), STRINGVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

