/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.EdgeStatistics;

@SdkInternalApi
public class EdgeStatisticsMarshaller {
    private static final MarshallingInfo<Long> OKCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OkCount").build();
    private static final MarshallingInfo<StructuredPojo> ERRORSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorStatistics").build();
    private static final MarshallingInfo<StructuredPojo> FAULTSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaultStatistics").build();
    private static final MarshallingInfo<Long> TOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCount").build();
    private static final MarshallingInfo<Double> TOTALRESPONSETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalResponseTime").build();
    private static final EdgeStatisticsMarshaller INSTANCE = new EdgeStatisticsMarshaller();

    public static EdgeStatisticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EdgeStatistics edgeStatistics, ProtocolMarshaller protocolMarshaller) {
        if (edgeStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)edgeStatistics.okCount(), OKCOUNT_BINDING);
            protocolMarshaller.marshall((Object)edgeStatistics.errorStatistics(), ERRORSTATISTICS_BINDING);
            protocolMarshaller.marshall((Object)edgeStatistics.faultStatistics(), FAULTSTATISTICS_BINDING);
            protocolMarshaller.marshall((Object)edgeStatistics.totalCount(), TOTALCOUNT_BINDING);
            protocolMarshaller.marshall((Object)edgeStatistics.totalResponseTime(), TOTALRESPONSETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

