/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.AnnotationsCopier;
import software.amazon.awssdk.services.xray.model.Http;
import software.amazon.awssdk.services.xray.model.ServiceId;
import software.amazon.awssdk.services.xray.model.ServiceIdsCopier;
import software.amazon.awssdk.services.xray.model.TraceUser;
import software.amazon.awssdk.services.xray.model.TraceUsersCopier;
import software.amazon.awssdk.services.xray.model.ValueWithServiceIds;
import software.amazon.awssdk.services.xray.transform.TraceSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TraceSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, TraceSummary> {
    private final String id;
    private final Double duration;
    private final Double responseTime;
    private final Boolean hasFault;
    private final Boolean hasError;
    private final Boolean hasThrottle;
    private final Boolean isPartial;
    private final Http http;
    private final Map<String, List<ValueWithServiceIds>> annotations;
    private final List<TraceUser> users;
    private final List<ServiceId> serviceIds;

    private TraceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.duration = builder.duration;
        this.responseTime = builder.responseTime;
        this.hasFault = builder.hasFault;
        this.hasError = builder.hasError;
        this.hasThrottle = builder.hasThrottle;
        this.isPartial = builder.isPartial;
        this.http = builder.http;
        this.annotations = builder.annotations;
        this.users = builder.users;
        this.serviceIds = builder.serviceIds;
    }

    public String id() {
        return this.id;
    }

    public Double duration() {
        return this.duration;
    }

    public Double responseTime() {
        return this.responseTime;
    }

    public Boolean hasFault() {
        return this.hasFault;
    }

    public Boolean hasError() {
        return this.hasError;
    }

    public Boolean hasThrottle() {
        return this.hasThrottle;
    }

    public Boolean isPartial() {
        return this.isPartial;
    }

    public Http http() {
        return this.http;
    }

    public Map<String, List<ValueWithServiceIds>> annotations() {
        return this.annotations;
    }

    public List<TraceUser> users() {
        return this.users;
    }

    public List<ServiceId> serviceIds() {
        return this.serviceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFault());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasError());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThrottle());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(this.http());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotations());
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceSummary)) {
            return false;
        }
        TraceSummary other = (TraceSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.responseTime(), other.responseTime()) && Objects.equals(this.hasFault(), other.hasFault()) && Objects.equals(this.hasError(), other.hasError()) && Objects.equals(this.hasThrottle(), other.hasThrottle()) && Objects.equals(this.isPartial(), other.isPartial()) && Objects.equals(this.http(), other.http()) && Objects.equals(this.annotations(), other.annotations()) && Objects.equals(this.users(), other.users()) && Objects.equals(this.serviceIds(), other.serviceIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.responseTime() != null) {
            sb.append("ResponseTime: ").append(this.responseTime()).append(",");
        }
        if (this.hasFault() != null) {
            sb.append("HasFault: ").append(this.hasFault()).append(",");
        }
        if (this.hasError() != null) {
            sb.append("HasError: ").append(this.hasError()).append(",");
        }
        if (this.hasThrottle() != null) {
            sb.append("HasThrottle: ").append(this.hasThrottle()).append(",");
        }
        if (this.isPartial() != null) {
            sb.append("IsPartial: ").append(this.isPartial()).append(",");
        }
        if (this.http() != null) {
            sb.append("Http: ").append(this.http()).append(",");
        }
        if (this.annotations() != null) {
            sb.append("Annotations: ").append(this.annotations()).append(",");
        }
        if (this.users() != null) {
            sb.append("Users: ").append(this.users()).append(",");
        }
        if (this.serviceIds() != null) {
            sb.append("ServiceIds: ").append(this.serviceIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "ResponseTime": {
                return Optional.of(clazz.cast(this.responseTime()));
            }
            case "HasFault": {
                return Optional.of(clazz.cast(this.hasFault()));
            }
            case "HasError": {
                return Optional.of(clazz.cast(this.hasError()));
            }
            case "HasThrottle": {
                return Optional.of(clazz.cast(this.hasThrottle()));
            }
            case "IsPartial": {
                return Optional.of(clazz.cast(this.isPartial()));
            }
            case "Http": {
                return Optional.of(clazz.cast(this.http()));
            }
            case "Annotations": {
                return Optional.of(clazz.cast(this.annotations()));
            }
            case "Users": {
                return Optional.of(clazz.cast(this.users()));
            }
            case "ServiceIds": {
                return Optional.of(clazz.cast(this.serviceIds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TraceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Double duration;
        private Double responseTime;
        private Boolean hasFault;
        private Boolean hasError;
        private Boolean hasThrottle;
        private Boolean isPartial;
        private Http http;
        private Map<String, List<ValueWithServiceIds>> annotations;
        private List<TraceUser> users;
        private List<ServiceId> serviceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(TraceSummary model) {
            this.id(model.id);
            this.duration(model.duration);
            this.responseTime(model.responseTime);
            this.hasFault(model.hasFault);
            this.hasError(model.hasError);
            this.hasThrottle(model.hasThrottle);
            this.isPartial(model.isPartial);
            this.http(model.http);
            this.annotations(model.annotations);
            this.users(model.users);
            this.serviceIds(model.serviceIds);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Double getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        public final Double getResponseTime() {
            return this.responseTime;
        }

        @Override
        public final Builder responseTime(Double responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public final void setResponseTime(Double responseTime) {
            this.responseTime = responseTime;
        }

        public final Boolean getHasFault() {
            return this.hasFault;
        }

        @Override
        public final Builder hasFault(Boolean hasFault) {
            this.hasFault = hasFault;
            return this;
        }

        public final void setHasFault(Boolean hasFault) {
            this.hasFault = hasFault;
        }

        public final Boolean getHasError() {
            return this.hasError;
        }

        @Override
        public final Builder hasError(Boolean hasError) {
            this.hasError = hasError;
            return this;
        }

        public final void setHasError(Boolean hasError) {
            this.hasError = hasError;
        }

        public final Boolean getHasThrottle() {
            return this.hasThrottle;
        }

        @Override
        public final Builder hasThrottle(Boolean hasThrottle) {
            this.hasThrottle = hasThrottle;
            return this;
        }

        public final void setHasThrottle(Boolean hasThrottle) {
            this.hasThrottle = hasThrottle;
        }

        public final Boolean getIsPartial() {
            return this.isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        public final Http.Builder getHttp() {
            return this.http != null ? this.http.toBuilder() : null;
        }

        @Override
        public final Builder http(Http http) {
            this.http = http;
            return this;
        }

        public final void setHttp(Http.BuilderImpl http) {
            this.http = http != null ? http.build() : null;
        }

        public final Map<String, ? extends Collection<ValueWithServiceIds>> getAnnotations() {
            return this.annotations;
        }

        @Override
        public final Builder annotations(Map<String, ? extends Collection<ValueWithServiceIds>> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
            return this;
        }

        public final void setAnnotations(Map<String, ? extends Collection<ValueWithServiceIds>> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
        }

        public final Collection<TraceUser.Builder> getUsers() {
            return this.users != null ? (Collection)this.users.stream().map(TraceUser::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<TraceUser> users) {
            this.users = TraceUsersCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(TraceUser ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        public final void setUsers(Collection<TraceUser.BuilderImpl> users) {
            this.users = TraceUsersCopier.copyFromBuilder(users);
        }

        public final Collection<ServiceId.Builder> getServiceIds() {
            return this.serviceIds != null ? (Collection)this.serviceIds.stream().map(ServiceId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(ServiceId ... serviceIds) {
            this.serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        public final void setServiceIds(Collection<ServiceId.BuilderImpl> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copyFromBuilder(serviceIds);
        }

        public TraceSummary build() {
            return new TraceSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TraceSummary> {
        public Builder id(String var1);

        public Builder duration(Double var1);

        public Builder responseTime(Double var1);

        public Builder hasFault(Boolean var1);

        public Builder hasError(Boolean var1);

        public Builder hasThrottle(Boolean var1);

        public Builder isPartial(Boolean var1);

        public Builder http(Http var1);

        default public Builder http(Consumer<Http.Builder> http) {
            return this.http((Http)((Http.Builder)Http.builder().apply(http)).build());
        }

        public Builder annotations(Map<String, ? extends Collection<ValueWithServiceIds>> var1);

        public Builder users(Collection<TraceUser> var1);

        public Builder users(TraceUser ... var1);

        public Builder serviceIds(Collection<ServiceId> var1);

        public Builder serviceIds(ServiceId ... var1);
    }
}

