/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.transform.HttpMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Http
implements StructuredPojo,
ToCopyableBuilder<Builder, Http> {
    private final String httpURL;
    private final Integer httpStatus;
    private final String httpMethod;
    private final String userAgent;
    private final String clientIp;

    private Http(BuilderImpl builder) {
        this.httpURL = builder.httpURL;
        this.httpStatus = builder.httpStatus;
        this.httpMethod = builder.httpMethod;
        this.userAgent = builder.userAgent;
        this.clientIp = builder.clientIp;
    }

    public String httpURL() {
        return this.httpURL;
    }

    public Integer httpStatus() {
        return this.httpStatus;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public String clientIp() {
        return this.clientIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAgent());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Http)) {
            return false;
        }
        Http other = (Http)obj;
        return Objects.equals(this.httpURL(), other.httpURL()) && Objects.equals(this.httpStatus(), other.httpStatus()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.userAgent(), other.userAgent()) && Objects.equals(this.clientIp(), other.clientIp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.httpURL() != null) {
            sb.append("HttpURL: ").append(this.httpURL()).append(",");
        }
        if (this.httpStatus() != null) {
            sb.append("HttpStatus: ").append(this.httpStatus()).append(",");
        }
        if (this.httpMethod() != null) {
            sb.append("HttpMethod: ").append(this.httpMethod()).append(",");
        }
        if (this.userAgent() != null) {
            sb.append("UserAgent: ").append(this.userAgent()).append(",");
        }
        if (this.clientIp() != null) {
            sb.append("ClientIp: ").append(this.clientIp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpURL": {
                return Optional.of(clazz.cast(this.httpURL()));
            }
            case "HttpStatus": {
                return Optional.of(clazz.cast(this.httpStatus()));
            }
            case "HttpMethod": {
                return Optional.of(clazz.cast(this.httpMethod()));
            }
            case "UserAgent": {
                return Optional.of(clazz.cast(this.userAgent()));
            }
            case "ClientIp": {
                return Optional.of(clazz.cast(this.clientIp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HttpMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpURL;
        private Integer httpStatus;
        private String httpMethod;
        private String userAgent;
        private String clientIp;

        private BuilderImpl() {
        }

        private BuilderImpl(Http model) {
            this.httpURL(model.httpURL);
            this.httpStatus(model.httpStatus);
            this.httpMethod(model.httpMethod);
            this.userAgent(model.userAgent);
            this.clientIp(model.clientIp);
        }

        public final String getHttpURL() {
            return this.httpURL;
        }

        @Override
        public final Builder httpURL(String httpURL) {
            this.httpURL = httpURL;
            return this;
        }

        public final void setHttpURL(String httpURL) {
            this.httpURL = httpURL;
        }

        public final Integer getHttpStatus() {
            return this.httpStatus;
        }

        @Override
        public final Builder httpStatus(Integer httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public final void setHttpStatus(Integer httpStatus) {
            this.httpStatus = httpStatus;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getUserAgent() {
            return this.userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public final String getClientIp() {
            return this.clientIp;
        }

        @Override
        public final Builder clientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        public final void setClientIp(String clientIp) {
            this.clientIp = clientIp;
        }

        public Http build() {
            return new Http(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Http> {
        public Builder httpURL(String var1);

        public Builder httpStatus(Integer var1);

        public Builder httpMethod(String var1);

        public Builder userAgent(String var1);

        public Builder clientIp(String var1);
    }
}

