/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.ValueWithServiceIds;

@SdkInternalApi
public class ValueWithServiceIdsMarshaller {
    private static final MarshallingInfo<StructuredPojo> ANNOTATIONVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnnotationValue").build();
    private static final MarshallingInfo<List> SERVICEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceIds").build();
    private static final ValueWithServiceIdsMarshaller INSTANCE = new ValueWithServiceIdsMarshaller();

    public static ValueWithServiceIdsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ValueWithServiceIds valueWithServiceIds, ProtocolMarshaller protocolMarshaller) {
        if (valueWithServiceIds == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)valueWithServiceIds.annotationValue(), ANNOTATIONVALUE_BINDING);
            protocolMarshaller.marshall(valueWithServiceIds.serviceIds(), SERVICEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

