/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.TraceUser;

@SdkInternalApi
public class TraceUserMarshaller {
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserName").build();
    private static final MarshallingInfo<List> SERVICEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceIds").build();
    private static final TraceUserMarshaller INSTANCE = new TraceUserMarshaller();

    public static TraceUserMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TraceUser traceUser, ProtocolMarshaller protocolMarshaller) {
        if (traceUser == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)traceUser.userName(), USERNAME_BINDING);
            protocolMarshaller.marshall(traceUser.serviceIds(), SERVICEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

