/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.TraceSummary;

@SdkInternalApi
public class TraceSummaryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<Double> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").build();
    private static final MarshallingInfo<Double> RESPONSETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseTime").build();
    private static final MarshallingInfo<Boolean> HASFAULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasFault").build();
    private static final MarshallingInfo<Boolean> HASERROR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasError").build();
    private static final MarshallingInfo<Boolean> HASTHROTTLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasThrottle").build();
    private static final MarshallingInfo<Boolean> ISPARTIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsPartial").build();
    private static final MarshallingInfo<StructuredPojo> HTTP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Http").build();
    private static final MarshallingInfo<Map> ANNOTATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Annotations").build();
    private static final MarshallingInfo<List> USERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Users").build();
    private static final MarshallingInfo<List> SERVICEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceIds").build();
    private static final TraceSummaryMarshaller INSTANCE = new TraceSummaryMarshaller();

    public static TraceSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TraceSummary traceSummary, ProtocolMarshaller protocolMarshaller) {
        if (traceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)traceSummary.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)traceSummary.duration(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)traceSummary.responseTime(), RESPONSETIME_BINDING);
            protocolMarshaller.marshall((Object)traceSummary.hasFault(), HASFAULT_BINDING);
            protocolMarshaller.marshall((Object)traceSummary.hasError(), HASERROR_BINDING);
            protocolMarshaller.marshall((Object)traceSummary.hasThrottle(), HASTHROTTLE_BINDING);
            protocolMarshaller.marshall((Object)traceSummary.isPartial(), ISPARTIAL_BINDING);
            protocolMarshaller.marshall((Object)traceSummary.http(), HTTP_BINDING);
            protocolMarshaller.marshall(traceSummary.annotations(), ANNOTATIONS_BINDING);
            protocolMarshaller.marshall(traceSummary.users(), USERS_BINDING);
            protocolMarshaller.marshall(traceSummary.serviceIds(), SERVICEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

