/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.Edge;
import software.amazon.awssdk.services.xray.model.EdgeListCopier;
import software.amazon.awssdk.services.xray.model.HistogramCopier;
import software.amazon.awssdk.services.xray.model.HistogramEntry;
import software.amazon.awssdk.services.xray.model.ServiceNamesCopier;
import software.amazon.awssdk.services.xray.model.ServiceStatistics;
import software.amazon.awssdk.services.xray.transform.ServiceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Service
implements StructuredPojo,
ToCopyableBuilder<Builder, Service> {
    private final Integer referenceId;
    private final String name;
    private final List<String> names;
    private final Boolean root;
    private final String accountId;
    private final String type;
    private final String state;
    private final Instant startTime;
    private final Instant endTime;
    private final List<Edge> edges;
    private final ServiceStatistics summaryStatistics;
    private final List<HistogramEntry> durationHistogram;
    private final List<HistogramEntry> responseTimeHistogram;

    private Service(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.name = builder.name;
        this.names = builder.names;
        this.root = builder.root;
        this.accountId = builder.accountId;
        this.type = builder.type;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.edges = builder.edges;
        this.summaryStatistics = builder.summaryStatistics;
        this.durationHistogram = builder.durationHistogram;
        this.responseTimeHistogram = builder.responseTimeHistogram;
    }

    public Integer referenceId() {
        return this.referenceId;
    }

    public String name() {
        return this.name;
    }

    public List<String> names() {
        return this.names;
    }

    public Boolean root() {
        return this.root;
    }

    public String accountId() {
        return this.accountId;
    }

    public String type() {
        return this.type;
    }

    public String state() {
        return this.state;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public List<Edge> edges() {
        return this.edges;
    }

    public ServiceStatistics summaryStatistics() {
        return this.summaryStatistics;
    }

    public List<HistogramEntry> durationHistogram() {
        return this.durationHistogram;
    }

    public List<HistogramEntry> responseTimeHistogram() {
        return this.responseTimeHistogram;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.referenceId() == null ? 0 : this.referenceId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.names() == null ? 0 : this.names().hashCode());
        hashCode = 31 * hashCode + (this.root() == null ? 0 : this.root().hashCode());
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.edges() == null ? 0 : this.edges().hashCode());
        hashCode = 31 * hashCode + (this.summaryStatistics() == null ? 0 : this.summaryStatistics().hashCode());
        hashCode = 31 * hashCode + (this.durationHistogram() == null ? 0 : this.durationHistogram().hashCode());
        hashCode = 31 * hashCode + (this.responseTimeHistogram() == null ? 0 : this.responseTimeHistogram().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        if (other.referenceId() == null ^ this.referenceId() == null) {
            return false;
        }
        if (other.referenceId() != null && !other.referenceId().equals(this.referenceId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.names() == null ^ this.names() == null) {
            return false;
        }
        if (other.names() != null && !other.names().equals(this.names())) {
            return false;
        }
        if (other.root() == null ^ this.root() == null) {
            return false;
        }
        if (other.root() != null && !other.root().equals(this.root())) {
            return false;
        }
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.edges() == null ^ this.edges() == null) {
            return false;
        }
        if (other.edges() != null && !other.edges().equals(this.edges())) {
            return false;
        }
        if (other.summaryStatistics() == null ^ this.summaryStatistics() == null) {
            return false;
        }
        if (other.summaryStatistics() != null && !other.summaryStatistics().equals(this.summaryStatistics())) {
            return false;
        }
        if (other.durationHistogram() == null ^ this.durationHistogram() == null) {
            return false;
        }
        if (other.durationHistogram() != null && !other.durationHistogram().equals(this.durationHistogram())) {
            return false;
        }
        if (other.responseTimeHistogram() == null ^ this.responseTimeHistogram() == null) {
            return false;
        }
        return other.responseTimeHistogram() == null || other.responseTimeHistogram().equals(this.responseTimeHistogram());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.referenceId() != null) {
            sb.append("ReferenceId: ").append(this.referenceId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.names() != null) {
            sb.append("Names: ").append(this.names()).append(",");
        }
        if (this.root() != null) {
            sb.append("Root: ").append(this.root()).append(",");
        }
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.edges() != null) {
            sb.append("Edges: ").append(this.edges()).append(",");
        }
        if (this.summaryStatistics() != null) {
            sb.append("SummaryStatistics: ").append(this.summaryStatistics()).append(",");
        }
        if (this.durationHistogram() != null) {
            sb.append("DurationHistogram: ").append(this.durationHistogram()).append(",");
        }
        if (this.responseTimeHistogram() != null) {
            sb.append("ResponseTimeHistogram: ").append(this.responseTimeHistogram()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceId": {
                return Optional.of(clazz.cast(this.referenceId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Names": {
                return Optional.of(clazz.cast(this.names()));
            }
            case "Root": {
                return Optional.of(clazz.cast(this.root()));
            }
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.type()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.state()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "Edges": {
                return Optional.of(clazz.cast(this.edges()));
            }
            case "SummaryStatistics": {
                return Optional.of(clazz.cast(this.summaryStatistics()));
            }
            case "DurationHistogram": {
                return Optional.of(clazz.cast(this.durationHistogram()));
            }
            case "ResponseTimeHistogram": {
                return Optional.of(clazz.cast(this.responseTimeHistogram()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer referenceId;
        private String name;
        private List<String> names;
        private Boolean root;
        private String accountId;
        private String type;
        private String state;
        private Instant startTime;
        private Instant endTime;
        private List<Edge> edges;
        private ServiceStatistics summaryStatistics;
        private List<HistogramEntry> durationHistogram;
        private List<HistogramEntry> responseTimeHistogram;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.referenceId(model.referenceId);
            this.name(model.name);
            this.names(model.names);
            this.root(model.root);
            this.accountId(model.accountId);
            this.type(model.type);
            this.state(model.state);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.edges(model.edges);
            this.summaryStatistics(model.summaryStatistics);
            this.durationHistogram(model.durationHistogram);
            this.responseTimeHistogram(model.responseTimeHistogram);
        }

        public final Integer getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(Integer referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(Integer referenceId) {
            this.referenceId = referenceId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getNames() {
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
        }

        public final Boolean getRoot() {
            return this.root;
        }

        @Override
        public final Builder root(Boolean root) {
            this.root = root;
            return this;
        }

        public final void setRoot(Boolean root) {
            this.root = root;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<Edge.Builder> getEdges() {
            return this.edges != null ? (Collection)this.edges.stream().map(Edge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder edges(Collection<Edge> edges) {
            this.edges = EdgeListCopier.copy(edges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Edge ... edges) {
            this.edges(Arrays.asList(edges));
            return this;
        }

        public final void setEdges(Collection<Edge.BuilderImpl> edges) {
            this.edges = EdgeListCopier.copyFromBuilder(edges);
        }

        public final ServiceStatistics.Builder getSummaryStatistics() {
            return this.summaryStatistics != null ? this.summaryStatistics.toBuilder() : null;
        }

        @Override
        public final Builder summaryStatistics(ServiceStatistics summaryStatistics) {
            this.summaryStatistics = summaryStatistics;
            return this;
        }

        public final void setSummaryStatistics(ServiceStatistics.BuilderImpl summaryStatistics) {
            this.summaryStatistics = summaryStatistics != null ? summaryStatistics.build() : null;
        }

        public final Collection<HistogramEntry.Builder> getDurationHistogram() {
            return this.durationHistogram != null ? (Collection)this.durationHistogram.stream().map(HistogramEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder durationHistogram(Collection<HistogramEntry> durationHistogram) {
            this.durationHistogram = HistogramCopier.copy(durationHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durationHistogram(HistogramEntry ... durationHistogram) {
            this.durationHistogram(Arrays.asList(durationHistogram));
            return this;
        }

        public final void setDurationHistogram(Collection<HistogramEntry.BuilderImpl> durationHistogram) {
            this.durationHistogram = HistogramCopier.copyFromBuilder(durationHistogram);
        }

        public final Collection<HistogramEntry.Builder> getResponseTimeHistogram() {
            return this.responseTimeHistogram != null ? (Collection)this.responseTimeHistogram.stream().map(HistogramEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copy(responseTimeHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(HistogramEntry ... responseTimeHistogram) {
            this.responseTimeHistogram(Arrays.asList(responseTimeHistogram));
            return this;
        }

        public final void setResponseTimeHistogram(Collection<HistogramEntry.BuilderImpl> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copyFromBuilder(responseTimeHistogram);
        }

        public Service build() {
            return new Service(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Service> {
        public Builder referenceId(Integer var1);

        public Builder name(String var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder root(Boolean var1);

        public Builder accountId(String var1);

        public Builder type(String var1);

        public Builder state(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder edges(Collection<Edge> var1);

        public Builder edges(Edge ... var1);

        public Builder summaryStatistics(ServiceStatistics var1);

        public Builder durationHistogram(Collection<HistogramEntry> var1);

        public Builder durationHistogram(HistogramEntry ... var1);

        public Builder responseTimeHistogram(Collection<HistogramEntry> var1);

        public Builder responseTimeHistogram(HistogramEntry ... var1);
    }
}

