/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.transform.HistogramEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HistogramEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, HistogramEntry> {
    private final Double value;
    private final Integer count;

    private HistogramEntry(BuilderImpl builder) {
        this.value = builder.value;
        this.count = builder.count;
    }

    public Double value() {
        return this.value;
    }

    public Integer count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.count() == null ? 0 : this.count().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistogramEntry)) {
            return false;
        }
        HistogramEntry other = (HistogramEntry)obj;
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        return other.count() == null || other.count().equals(this.count());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "Count": {
                return Optional.of(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HistogramEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double value;
        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(HistogramEntry model) {
            this.value(model.value);
            this.count(model.count);
        }

        public final Double getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public HistogramEntry build() {
            return new HistogramEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HistogramEntry> {
        public Builder value(Double var1);

        public Builder count(Integer var1);
    }
}

