/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.ErrorStatistics;
import software.amazon.awssdk.services.xray.model.FaultStatistics;
import software.amazon.awssdk.services.xray.transform.EdgeStatisticsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EdgeStatistics
implements StructuredPojo,
ToCopyableBuilder<Builder, EdgeStatistics> {
    private final Long okCount;
    private final ErrorStatistics errorStatistics;
    private final FaultStatistics faultStatistics;
    private final Long totalCount;
    private final Double totalResponseTime;

    private EdgeStatistics(BuilderImpl builder) {
        this.okCount = builder.okCount;
        this.errorStatistics = builder.errorStatistics;
        this.faultStatistics = builder.faultStatistics;
        this.totalCount = builder.totalCount;
        this.totalResponseTime = builder.totalResponseTime;
    }

    public Long okCount() {
        return this.okCount;
    }

    public ErrorStatistics errorStatistics() {
        return this.errorStatistics;
    }

    public FaultStatistics faultStatistics() {
        return this.faultStatistics;
    }

    public Long totalCount() {
        return this.totalCount;
    }

    public Double totalResponseTime() {
        return this.totalResponseTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.okCount() == null ? 0 : this.okCount().hashCode());
        hashCode = 31 * hashCode + (this.errorStatistics() == null ? 0 : this.errorStatistics().hashCode());
        hashCode = 31 * hashCode + (this.faultStatistics() == null ? 0 : this.faultStatistics().hashCode());
        hashCode = 31 * hashCode + (this.totalCount() == null ? 0 : this.totalCount().hashCode());
        hashCode = 31 * hashCode + (this.totalResponseTime() == null ? 0 : this.totalResponseTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeStatistics)) {
            return false;
        }
        EdgeStatistics other = (EdgeStatistics)obj;
        if (other.okCount() == null ^ this.okCount() == null) {
            return false;
        }
        if (other.okCount() != null && !other.okCount().equals(this.okCount())) {
            return false;
        }
        if (other.errorStatistics() == null ^ this.errorStatistics() == null) {
            return false;
        }
        if (other.errorStatistics() != null && !other.errorStatistics().equals(this.errorStatistics())) {
            return false;
        }
        if (other.faultStatistics() == null ^ this.faultStatistics() == null) {
            return false;
        }
        if (other.faultStatistics() != null && !other.faultStatistics().equals(this.faultStatistics())) {
            return false;
        }
        if (other.totalCount() == null ^ this.totalCount() == null) {
            return false;
        }
        if (other.totalCount() != null && !other.totalCount().equals(this.totalCount())) {
            return false;
        }
        if (other.totalResponseTime() == null ^ this.totalResponseTime() == null) {
            return false;
        }
        return other.totalResponseTime() == null || other.totalResponseTime().equals(this.totalResponseTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.okCount() != null) {
            sb.append("OkCount: ").append(this.okCount()).append(",");
        }
        if (this.errorStatistics() != null) {
            sb.append("ErrorStatistics: ").append(this.errorStatistics()).append(",");
        }
        if (this.faultStatistics() != null) {
            sb.append("FaultStatistics: ").append(this.faultStatistics()).append(",");
        }
        if (this.totalCount() != null) {
            sb.append("TotalCount: ").append(this.totalCount()).append(",");
        }
        if (this.totalResponseTime() != null) {
            sb.append("TotalResponseTime: ").append(this.totalResponseTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OkCount": {
                return Optional.of(clazz.cast(this.okCount()));
            }
            case "ErrorStatistics": {
                return Optional.of(clazz.cast(this.errorStatistics()));
            }
            case "FaultStatistics": {
                return Optional.of(clazz.cast(this.faultStatistics()));
            }
            case "TotalCount": {
                return Optional.of(clazz.cast(this.totalCount()));
            }
            case "TotalResponseTime": {
                return Optional.of(clazz.cast(this.totalResponseTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EdgeStatisticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long okCount;
        private ErrorStatistics errorStatistics;
        private FaultStatistics faultStatistics;
        private Long totalCount;
        private Double totalResponseTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeStatistics model) {
            this.okCount(model.okCount);
            this.errorStatistics(model.errorStatistics);
            this.faultStatistics(model.faultStatistics);
            this.totalCount(model.totalCount);
            this.totalResponseTime(model.totalResponseTime);
        }

        public final Long getOkCount() {
            return this.okCount;
        }

        @Override
        public final Builder okCount(Long okCount) {
            this.okCount = okCount;
            return this;
        }

        public final void setOkCount(Long okCount) {
            this.okCount = okCount;
        }

        public final ErrorStatistics.Builder getErrorStatistics() {
            return this.errorStatistics != null ? this.errorStatistics.toBuilder() : null;
        }

        @Override
        public final Builder errorStatistics(ErrorStatistics errorStatistics) {
            this.errorStatistics = errorStatistics;
            return this;
        }

        public final void setErrorStatistics(ErrorStatistics.BuilderImpl errorStatistics) {
            this.errorStatistics = errorStatistics != null ? errorStatistics.build() : null;
        }

        public final FaultStatistics.Builder getFaultStatistics() {
            return this.faultStatistics != null ? this.faultStatistics.toBuilder() : null;
        }

        @Override
        public final Builder faultStatistics(FaultStatistics faultStatistics) {
            this.faultStatistics = faultStatistics;
            return this;
        }

        public final void setFaultStatistics(FaultStatistics.BuilderImpl faultStatistics) {
            this.faultStatistics = faultStatistics != null ? faultStatistics.build() : null;
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        public final Double getTotalResponseTime() {
            return this.totalResponseTime;
        }

        @Override
        public final Builder totalResponseTime(Double totalResponseTime) {
            this.totalResponseTime = totalResponseTime;
            return this;
        }

        public final void setTotalResponseTime(Double totalResponseTime) {
            this.totalResponseTime = totalResponseTime;
        }

        public EdgeStatistics build() {
            return new EdgeStatistics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EdgeStatistics> {
        public Builder okCount(Long var1);

        public Builder errorStatistics(ErrorStatistics var1);

        public Builder faultStatistics(FaultStatistics var1);

        public Builder totalCount(Long var1);

        public Builder totalResponseTime(Double var1);
    }
}

