/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.ServiceStatistics;

@SdkInternalApi
public class ServiceStatisticsMarshaller {
    private static final MarshallingInfo<Long> OKCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OkCount").build();
    private static final MarshallingInfo<StructuredPojo> ERRORSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorStatistics").build();
    private static final MarshallingInfo<StructuredPojo> FAULTSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaultStatistics").build();
    private static final MarshallingInfo<Long> TOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCount").build();
    private static final MarshallingInfo<Double> TOTALRESPONSETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalResponseTime").build();
    private static final ServiceStatisticsMarshaller INSTANCE = new ServiceStatisticsMarshaller();

    public static ServiceStatisticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ServiceStatistics serviceStatistics, ProtocolMarshaller protocolMarshaller) {
        if (serviceStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)serviceStatistics.okCount(), OKCOUNT_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.errorStatistics(), ERRORSTATISTICS_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.faultStatistics(), FAULTSTATISTICS_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.totalCount(), TOTALCOUNT_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.totalResponseTime(), TOTALRESPONSETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

