/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.FaultStatistics;

public class FaultStatisticsUnmarshaller
implements Unmarshaller<FaultStatistics, JsonUnmarshallerContext> {
    private static final FaultStatisticsUnmarshaller INSTANCE = new FaultStatisticsUnmarshaller();

    public FaultStatistics unmarshall(JsonUnmarshallerContext context) throws Exception {
        FaultStatistics.Builder faultStatisticsBuilder = FaultStatistics.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OtherCount", targetDepth)) {
                    context.nextToken();
                    faultStatisticsBuilder.otherCount((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("TotalCount", targetDepth)) {
                    context.nextToken();
                    faultStatisticsBuilder.totalCount((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (FaultStatistics)faultStatisticsBuilder.build();
    }

    public static FaultStatisticsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

