/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.BatchGetTracesRequest;

@SdkInternalApi
public class BatchGetTracesRequestModelMarshaller {
    private static final MarshallingInfo<List> TRACEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TraceIds").build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").build();
    private static final BatchGetTracesRequestModelMarshaller INSTANCE = new BatchGetTracesRequestModelMarshaller();

    public static BatchGetTracesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchGetTracesRequest batchGetTracesRequest, ProtocolMarshaller protocolMarshaller) {
        if (batchGetTracesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(batchGetTracesRequest.traceIds(), TRACEIDS_BINDING);
            protocolMarshaller.marshall((Object)batchGetTracesRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

