/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.AnnotationsCopier;
import software.amazon.awssdk.services.xray.model.Http;
import software.amazon.awssdk.services.xray.model.ServiceId;
import software.amazon.awssdk.services.xray.model.ServiceIdsCopier;
import software.amazon.awssdk.services.xray.model.TraceUser;
import software.amazon.awssdk.services.xray.model.TraceUsersCopier;
import software.amazon.awssdk.services.xray.model.ValueWithServiceIds;
import software.amazon.awssdk.services.xray.transform.TraceSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TraceSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, TraceSummary> {
    private final String id;
    private final Double duration;
    private final Double responseTime;
    private final Boolean hasFault;
    private final Boolean hasError;
    private final Boolean hasThrottle;
    private final Boolean isPartial;
    private final Http http;
    private final Map<String, List<ValueWithServiceIds>> annotations;
    private final List<TraceUser> users;
    private final List<ServiceId> serviceIds;

    private TraceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.duration = builder.duration;
        this.responseTime = builder.responseTime;
        this.hasFault = builder.hasFault;
        this.hasError = builder.hasError;
        this.hasThrottle = builder.hasThrottle;
        this.isPartial = builder.isPartial;
        this.http = builder.http;
        this.annotations = builder.annotations;
        this.users = builder.users;
        this.serviceIds = builder.serviceIds;
    }

    public String id() {
        return this.id;
    }

    public Double duration() {
        return this.duration;
    }

    public Double responseTime() {
        return this.responseTime;
    }

    public Boolean hasFault() {
        return this.hasFault;
    }

    public Boolean hasError() {
        return this.hasError;
    }

    public Boolean hasThrottle() {
        return this.hasThrottle;
    }

    public Boolean isPartial() {
        return this.isPartial;
    }

    public Http http() {
        return this.http;
    }

    public Map<String, List<ValueWithServiceIds>> annotations() {
        return this.annotations;
    }

    public List<TraceUser> users() {
        return this.users;
    }

    public List<ServiceId> serviceIds() {
        return this.serviceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.responseTime() == null ? 0 : this.responseTime().hashCode());
        hashCode = 31 * hashCode + (this.hasFault() == null ? 0 : this.hasFault().hashCode());
        hashCode = 31 * hashCode + (this.hasError() == null ? 0 : this.hasError().hashCode());
        hashCode = 31 * hashCode + (this.hasThrottle() == null ? 0 : this.hasThrottle().hashCode());
        hashCode = 31 * hashCode + (this.isPartial() == null ? 0 : this.isPartial().hashCode());
        hashCode = 31 * hashCode + (this.http() == null ? 0 : this.http().hashCode());
        hashCode = 31 * hashCode + (this.annotations() == null ? 0 : this.annotations().hashCode());
        hashCode = 31 * hashCode + (this.users() == null ? 0 : this.users().hashCode());
        hashCode = 31 * hashCode + (this.serviceIds() == null ? 0 : this.serviceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceSummary)) {
            return false;
        }
        TraceSummary other = (TraceSummary)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.responseTime() == null ^ this.responseTime() == null) {
            return false;
        }
        if (other.responseTime() != null && !other.responseTime().equals(this.responseTime())) {
            return false;
        }
        if (other.hasFault() == null ^ this.hasFault() == null) {
            return false;
        }
        if (other.hasFault() != null && !other.hasFault().equals(this.hasFault())) {
            return false;
        }
        if (other.hasError() == null ^ this.hasError() == null) {
            return false;
        }
        if (other.hasError() != null && !other.hasError().equals(this.hasError())) {
            return false;
        }
        if (other.hasThrottle() == null ^ this.hasThrottle() == null) {
            return false;
        }
        if (other.hasThrottle() != null && !other.hasThrottle().equals(this.hasThrottle())) {
            return false;
        }
        if (other.isPartial() == null ^ this.isPartial() == null) {
            return false;
        }
        if (other.isPartial() != null && !other.isPartial().equals(this.isPartial())) {
            return false;
        }
        if (other.http() == null ^ this.http() == null) {
            return false;
        }
        if (other.http() != null && !other.http().equals(this.http())) {
            return false;
        }
        if (other.annotations() == null ^ this.annotations() == null) {
            return false;
        }
        if (other.annotations() != null && !other.annotations().equals(this.annotations())) {
            return false;
        }
        if (other.users() == null ^ this.users() == null) {
            return false;
        }
        if (other.users() != null && !other.users().equals(this.users())) {
            return false;
        }
        if (other.serviceIds() == null ^ this.serviceIds() == null) {
            return false;
        }
        return other.serviceIds() == null || other.serviceIds().equals(this.serviceIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.responseTime() != null) {
            sb.append("ResponseTime: ").append(this.responseTime()).append(",");
        }
        if (this.hasFault() != null) {
            sb.append("HasFault: ").append(this.hasFault()).append(",");
        }
        if (this.hasError() != null) {
            sb.append("HasError: ").append(this.hasError()).append(",");
        }
        if (this.hasThrottle() != null) {
            sb.append("HasThrottle: ").append(this.hasThrottle()).append(",");
        }
        if (this.isPartial() != null) {
            sb.append("IsPartial: ").append(this.isPartial()).append(",");
        }
        if (this.http() != null) {
            sb.append("Http: ").append(this.http()).append(",");
        }
        if (this.annotations() != null) {
            sb.append("Annotations: ").append(this.annotations()).append(",");
        }
        if (this.users() != null) {
            sb.append("Users: ").append(this.users()).append(",");
        }
        if (this.serviceIds() != null) {
            sb.append("ServiceIds: ").append(this.serviceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TraceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private Double duration;
        private Double responseTime;
        private Boolean hasFault;
        private Boolean hasError;
        private Boolean hasThrottle;
        private Boolean isPartial;
        private Http http;
        private Map<String, List<ValueWithServiceIds>> annotations;
        private List<TraceUser> users;
        private List<ServiceId> serviceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(TraceSummary model) {
            this.setId(model.id);
            this.setDuration(model.duration);
            this.setResponseTime(model.responseTime);
            this.setHasFault(model.hasFault);
            this.setHasError(model.hasError);
            this.setHasThrottle(model.hasThrottle);
            this.setIsPartial(model.isPartial);
            this.setHttp(model.http);
            this.setAnnotations(model.annotations);
            this.setUsers(model.users);
            this.setServiceIds(model.serviceIds);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Double getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        public final Double getResponseTime() {
            return this.responseTime;
        }

        @Override
        public final Builder responseTime(Double responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public final void setResponseTime(Double responseTime) {
            this.responseTime = responseTime;
        }

        public final Boolean getHasFault() {
            return this.hasFault;
        }

        @Override
        public final Builder hasFault(Boolean hasFault) {
            this.hasFault = hasFault;
            return this;
        }

        public final void setHasFault(Boolean hasFault) {
            this.hasFault = hasFault;
        }

        public final Boolean getHasError() {
            return this.hasError;
        }

        @Override
        public final Builder hasError(Boolean hasError) {
            this.hasError = hasError;
            return this;
        }

        public final void setHasError(Boolean hasError) {
            this.hasError = hasError;
        }

        public final Boolean getHasThrottle() {
            return this.hasThrottle;
        }

        @Override
        public final Builder hasThrottle(Boolean hasThrottle) {
            this.hasThrottle = hasThrottle;
            return this;
        }

        public final void setHasThrottle(Boolean hasThrottle) {
            this.hasThrottle = hasThrottle;
        }

        public final Boolean getIsPartial() {
            return this.isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        public final Http getHttp() {
            return this.http;
        }

        @Override
        public final Builder http(Http http) {
            this.http = http;
            return this;
        }

        public final void setHttp(Http http) {
            this.http = http;
        }

        public final Map<String, ? extends Collection<ValueWithServiceIds>> getAnnotations() {
            return this.annotations;
        }

        @Override
        public final Builder annotations(Map<String, ? extends Collection<ValueWithServiceIds>> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
            return this;
        }

        public final void setAnnotations(Map<String, ? extends Collection<ValueWithServiceIds>> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
        }

        public final Collection<TraceUser> getUsers() {
            return this.users;
        }

        @Override
        public final Builder users(Collection<TraceUser> users) {
            this.users = TraceUsersCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(TraceUser ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        public final void setUsers(Collection<TraceUser> users) {
            this.users = TraceUsersCopier.copy(users);
        }

        public final Collection<ServiceId> getServiceIds() {
            return this.serviceIds;
        }

        @Override
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(ServiceId ... serviceIds) {
            this.serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        public final void setServiceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
        }

        public TraceSummary build() {
            return new TraceSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TraceSummary> {
        public Builder id(String var1);

        public Builder duration(Double var1);

        public Builder responseTime(Double var1);

        public Builder hasFault(Boolean var1);

        public Builder hasError(Boolean var1);

        public Builder hasThrottle(Boolean var1);

        public Builder isPartial(Boolean var1);

        public Builder http(Http var1);

        public Builder annotations(Map<String, ? extends Collection<ValueWithServiceIds>> var1);

        public Builder users(Collection<TraceUser> var1);

        public Builder users(TraceUser ... var1);

        public Builder serviceIds(Collection<ServiceId> var1);

        public Builder serviceIds(ServiceId ... var1);
    }
}

