/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.transform.ErrorStatisticsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ErrorStatistics
implements StructuredPojo,
ToCopyableBuilder<Builder, ErrorStatistics> {
    private final Long throttleCount;
    private final Long otherCount;
    private final Long totalCount;

    private ErrorStatistics(BuilderImpl builder) {
        this.throttleCount = builder.throttleCount;
        this.otherCount = builder.otherCount;
        this.totalCount = builder.totalCount;
    }

    public Long throttleCount() {
        return this.throttleCount;
    }

    public Long otherCount() {
        return this.otherCount;
    }

    public Long totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.throttleCount() == null ? 0 : this.throttleCount().hashCode());
        hashCode = 31 * hashCode + (this.otherCount() == null ? 0 : this.otherCount().hashCode());
        hashCode = 31 * hashCode + (this.totalCount() == null ? 0 : this.totalCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorStatistics)) {
            return false;
        }
        ErrorStatistics other = (ErrorStatistics)obj;
        if (other.throttleCount() == null ^ this.throttleCount() == null) {
            return false;
        }
        if (other.throttleCount() != null && !other.throttleCount().equals(this.throttleCount())) {
            return false;
        }
        if (other.otherCount() == null ^ this.otherCount() == null) {
            return false;
        }
        if (other.otherCount() != null && !other.otherCount().equals(this.otherCount())) {
            return false;
        }
        if (other.totalCount() == null ^ this.totalCount() == null) {
            return false;
        }
        return other.totalCount() == null || other.totalCount().equals(this.totalCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.throttleCount() != null) {
            sb.append("ThrottleCount: ").append(this.throttleCount()).append(",");
        }
        if (this.otherCount() != null) {
            sb.append("OtherCount: ").append(this.otherCount()).append(",");
        }
        if (this.totalCount() != null) {
            sb.append("TotalCount: ").append(this.totalCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ErrorStatisticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Long throttleCount;
        private Long otherCount;
        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorStatistics model) {
            this.setThrottleCount(model.throttleCount);
            this.setOtherCount(model.otherCount);
            this.setTotalCount(model.totalCount);
        }

        public final Long getThrottleCount() {
            return this.throttleCount;
        }

        @Override
        public final Builder throttleCount(Long throttleCount) {
            this.throttleCount = throttleCount;
            return this;
        }

        public final void setThrottleCount(Long throttleCount) {
            this.throttleCount = throttleCount;
        }

        public final Long getOtherCount() {
            return this.otherCount;
        }

        @Override
        public final Builder otherCount(Long otherCount) {
            this.otherCount = otherCount;
            return this;
        }

        public final void setOtherCount(Long otherCount) {
            this.otherCount = otherCount;
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        public ErrorStatistics build() {
            return new ErrorStatistics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ErrorStatistics> {
        public Builder throttleCount(Long var1);

        public Builder otherCount(Long var1);

        public Builder totalCount(Long var1);
    }
}

