/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.HistogramEntry;

public class HistogramEntryUnmarshaller
implements Unmarshaller<HistogramEntry, JsonUnmarshallerContext> {
    private static HistogramEntryUnmarshaller INSTANCE;

    public HistogramEntry unmarshall(JsonUnmarshallerContext context) throws Exception {
        HistogramEntry.Builder histogramEntryBuilder = HistogramEntry.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    histogramEntryBuilder.value((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Count", targetDepth)) {
                    context.nextToken();
                    histogramEntryBuilder.count((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HistogramEntry)histogramEntryBuilder.build();
    }

    public static HistogramEntryUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HistogramEntryUnmarshaller();
        }
        return INSTANCE;
    }
}

