/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.Edge;
import software.amazon.awssdk.services.xray.transform.AliasUnmarshaller;
import software.amazon.awssdk.services.xray.transform.EdgeStatisticsUnmarshaller;
import software.amazon.awssdk.services.xray.transform.HistogramEntryUnmarshaller;

public class EdgeUnmarshaller
implements Unmarshaller<Edge, JsonUnmarshallerContext> {
    private static EdgeUnmarshaller INSTANCE;

    public Edge unmarshall(JsonUnmarshallerContext context) throws Exception {
        Edge.Builder edgeBuilder = Edge.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ReferenceId", targetDepth)) {
                    context.nextToken();
                    edgeBuilder.referenceId((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("StartTime", targetDepth)) {
                    context.nextToken();
                    edgeBuilder.startTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndTime", targetDepth)) {
                    context.nextToken();
                    edgeBuilder.endTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("SummaryStatistics", targetDepth)) {
                    context.nextToken();
                    edgeBuilder.summaryStatistics(EdgeStatisticsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ResponseTimeHistogram", targetDepth)) {
                    context.nextToken();
                    edgeBuilder.responseTimeHistogram(new ListUnmarshaller((Unmarshaller)HistogramEntryUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Aliases", targetDepth)) {
                    context.nextToken();
                    edgeBuilder.aliases(new ListUnmarshaller((Unmarshaller)AliasUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Edge)edgeBuilder.build();
    }

    public static EdgeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EdgeUnmarshaller();
        }
        return INSTANCE;
    }
}

