/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray;

import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.xray.DefaultXRayClientBuilder;
import software.amazon.awssdk.services.xray.XRayClientBuilder;
import software.amazon.awssdk.services.xray.model.BatchGetTracesRequest;
import software.amazon.awssdk.services.xray.model.BatchGetTracesResponse;
import software.amazon.awssdk.services.xray.model.GetServiceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetServiceGraphResponse;
import software.amazon.awssdk.services.xray.model.GetTraceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetTraceGraphResponse;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse;
import software.amazon.awssdk.services.xray.model.InvalidRequestException;
import software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest;
import software.amazon.awssdk.services.xray.model.PutTelemetryRecordsResponse;
import software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest;
import software.amazon.awssdk.services.xray.model.PutTraceSegmentsResponse;
import software.amazon.awssdk.services.xray.model.ThrottledException;
import software.amazon.awssdk.services.xray.model.XRayException;

public interface XRayClient
extends AutoCloseable {
    public static final String SERVICE_NAME = "xray";

    public static XRayClient create() {
        return (XRayClient)XRayClient.builder().build();
    }

    public static XRayClientBuilder builder() {
        return new DefaultXRayClientBuilder();
    }

    default public BatchGetTracesResponse batchGetTraces(BatchGetTracesRequest batchGetTracesRequest) throws InvalidRequestException, ThrottledException, SdkBaseException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    default public GetServiceGraphResponse getServiceGraph(GetServiceGraphRequest getServiceGraphRequest) throws InvalidRequestException, ThrottledException, SdkBaseException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    default public GetTraceGraphResponse getTraceGraph(GetTraceGraphRequest getTraceGraphRequest) throws InvalidRequestException, ThrottledException, SdkBaseException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    default public GetTraceSummariesResponse getTraceSummaries(GetTraceSummariesRequest getTraceSummariesRequest) throws InvalidRequestException, ThrottledException, SdkBaseException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    default public PutTelemetryRecordsResponse putTelemetryRecords(PutTelemetryRecordsRequest putTelemetryRecordsRequest) throws InvalidRequestException, ThrottledException, SdkBaseException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    default public PutTraceSegmentsResponse putTraceSegments(PutTraceSegmentsRequest putTraceSegmentsRequest) throws InvalidRequestException, ThrottledException, SdkBaseException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

