/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.SamplingRule;

public class SamplingRuleUnmarshaller
implements Unmarshaller<SamplingRule, JsonUnmarshallerContext> {
    private static final SamplingRuleUnmarshaller INSTANCE = new SamplingRuleUnmarshaller();

    public SamplingRule unmarshall(JsonUnmarshallerContext context) throws Exception {
        SamplingRule.Builder samplingRuleBuilder = SamplingRule.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("RuleName", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.ruleName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RuleARN", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.ruleARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourceARN", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.resourceARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Priority", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.priority((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("FixedRate", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.fixedRate((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReservoirSize", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.reservoirSize((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ServiceName", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.serviceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ServiceType", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.serviceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Host", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.host((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HTTPMethod", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.httpMethod((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("URLPath", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.urlPath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.version((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    samplingRuleBuilder.attributes(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SamplingRule)samplingRuleBuilder.build();
    }

    public static SamplingRuleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

