/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.SamplingRule;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SamplingRuleMarshaller {
    private static final MarshallingInfo<String> RULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleName").isBinary(false).build();
    private static final MarshallingInfo<String> RULEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleARN").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").isBinary(false).build();
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Priority").isBinary(false).build();
    private static final MarshallingInfo<Double> FIXEDRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FixedRate").isBinary(false).build();
    private static final MarshallingInfo<Integer> RESERVOIRSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservoirSize").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceName").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceType").isBinary(false).build();
    private static final MarshallingInfo<String> HOST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Host").isBinary(false).build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HTTPMethod").isBinary(false).build();
    private static final MarshallingInfo<String> URLPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("URLPath").isBinary(false).build();
    private static final MarshallingInfo<Integer> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final SamplingRuleMarshaller INSTANCE = new SamplingRuleMarshaller();

    private SamplingRuleMarshaller() {
    }

    public static SamplingRuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SamplingRule samplingRule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)samplingRule, (String)"samplingRule");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)samplingRule.ruleName(), RULENAME_BINDING);
            protocolMarshaller.marshall((Object)samplingRule.ruleARN(), RULEARN_BINDING);
            protocolMarshaller.marshall((Object)samplingRule.resourceARN(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)samplingRule.priority(), PRIORITY_BINDING);
            protocolMarshaller.marshall((Object)samplingRule.fixedRate(), FIXEDRATE_BINDING);
            protocolMarshaller.marshall((Object)samplingRule.reservoirSize(), RESERVOIRSIZE_BINDING);
            protocolMarshaller.marshall((Object)samplingRule.serviceName(), SERVICENAME_BINDING);
            protocolMarshaller.marshall((Object)samplingRule.serviceType(), SERVICETYPE_BINDING);
            protocolMarshaller.marshall((Object)samplingRule.host(), HOST_BINDING);
            protocolMarshaller.marshall((Object)samplingRule.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall((Object)samplingRule.urlPath(), URLPATH_BINDING);
            protocolMarshaller.marshall((Object)samplingRule.version(), VERSION_BINDING);
            protocolMarshaller.marshall(samplingRule.attributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

