/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.HistogramEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HistogramEntryMarshaller {
    private static final MarshallingInfo<Double> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Count").isBinary(false).build();
    private static final HistogramEntryMarshaller INSTANCE = new HistogramEntryMarshaller();

    private HistogramEntryMarshaller() {
    }

    public static HistogramEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HistogramEntry histogramEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)histogramEntry, (String)"histogramEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)histogramEntry.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)histogramEntry.count(), COUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

