/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.FaultStatistics;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FaultStatisticsMarshaller {
    private static final MarshallingInfo<Long> OTHERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OtherCount").isBinary(false).build();
    private static final MarshallingInfo<Long> TOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCount").isBinary(false).build();
    private static final FaultStatisticsMarshaller INSTANCE = new FaultStatisticsMarshaller();

    private FaultStatisticsMarshaller() {
    }

    public static FaultStatisticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FaultStatistics faultStatistics, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)faultStatistics, (String)"faultStatistics");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)faultStatistics.otherCount(), OTHERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)faultStatistics.totalCount(), TOTALCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

