/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.transform.SamplingStatisticsDocumentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamplingStatisticsDocument
implements StructuredPojo,
ToCopyableBuilder<Builder, SamplingStatisticsDocument> {
    private final String ruleName;
    private final String clientID;
    private final Instant timestamp;
    private final Integer requestCount;
    private final Integer sampledCount;
    private final Integer borrowCount;

    private SamplingStatisticsDocument(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.clientID = builder.clientID;
        this.timestamp = builder.timestamp;
        this.requestCount = builder.requestCount;
        this.sampledCount = builder.sampledCount;
        this.borrowCount = builder.borrowCount;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public String clientID() {
        return this.clientID;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Integer requestCount() {
        return this.requestCount;
    }

    public Integer sampledCount() {
        return this.sampledCount;
    }

    public Integer borrowCount() {
        return this.borrowCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientID());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampledCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.borrowCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingStatisticsDocument)) {
            return false;
        }
        SamplingStatisticsDocument other = (SamplingStatisticsDocument)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.clientID(), other.clientID()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.requestCount(), other.requestCount()) && Objects.equals(this.sampledCount(), other.sampledCount()) && Objects.equals(this.borrowCount(), other.borrowCount());
    }

    public String toString() {
        return ToString.builder((String)"SamplingStatisticsDocument").add("RuleName", (Object)this.ruleName()).add("ClientID", (Object)this.clientID()).add("Timestamp", (Object)this.timestamp()).add("RequestCount", (Object)this.requestCount()).add("SampledCount", (Object)this.sampledCount()).add("BorrowCount", (Object)this.borrowCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "ClientID": {
                return Optional.ofNullable(clazz.cast(this.clientID()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "RequestCount": {
                return Optional.ofNullable(clazz.cast(this.requestCount()));
            }
            case "SampledCount": {
                return Optional.ofNullable(clazz.cast(this.sampledCount()));
            }
            case "BorrowCount": {
                return Optional.ofNullable(clazz.cast(this.borrowCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SamplingStatisticsDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private String clientID;
        private Instant timestamp;
        private Integer requestCount;
        private Integer sampledCount;
        private Integer borrowCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingStatisticsDocument model) {
            this.ruleName(model.ruleName);
            this.clientID(model.clientID);
            this.timestamp(model.timestamp);
            this.requestCount(model.requestCount);
            this.sampledCount(model.sampledCount);
            this.borrowCount(model.borrowCount);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getClientID() {
            return this.clientID;
        }

        @Override
        public final Builder clientID(String clientID) {
            this.clientID = clientID;
            return this;
        }

        public final void setClientID(String clientID) {
            this.clientID = clientID;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Integer getRequestCount() {
            return this.requestCount;
        }

        @Override
        public final Builder requestCount(Integer requestCount) {
            this.requestCount = requestCount;
            return this;
        }

        public final void setRequestCount(Integer requestCount) {
            this.requestCount = requestCount;
        }

        public final Integer getSampledCount() {
            return this.sampledCount;
        }

        @Override
        public final Builder sampledCount(Integer sampledCount) {
            this.sampledCount = sampledCount;
            return this;
        }

        public final void setSampledCount(Integer sampledCount) {
            this.sampledCount = sampledCount;
        }

        public final Integer getBorrowCount() {
            return this.borrowCount;
        }

        @Override
        public final Builder borrowCount(Integer borrowCount) {
            this.borrowCount = borrowCount;
            return this;
        }

        public final void setBorrowCount(Integer borrowCount) {
            this.borrowCount = borrowCount;
        }

        public SamplingStatisticsDocument build() {
            return new SamplingStatisticsDocument(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SamplingStatisticsDocument> {
        public Builder ruleName(String var1);

        public Builder clientID(String var1);

        public Builder timestamp(Instant var1);

        public Builder requestCount(Integer var1);

        public Builder sampledCount(Integer var1);

        public Builder borrowCount(Integer var1);
    }
}

