/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.xray.model.XRayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSamplingRuleRequest
extends XRayRequest
implements ToCopyableBuilder<Builder, DeleteSamplingRuleRequest> {
    private final String ruleName;
    private final String ruleARN;

    private DeleteSamplingRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.ruleARN = builder.ruleARN;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public String ruleARN() {
        return this.ruleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSamplingRuleRequest)) {
            return false;
        }
        DeleteSamplingRuleRequest other = (DeleteSamplingRuleRequest)((Object)obj);
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.ruleARN(), other.ruleARN());
    }

    public String toString() {
        return ToString.builder((String)"DeleteSamplingRuleRequest").add("RuleName", (Object)this.ruleName()).add("RuleARN", (Object)this.ruleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "RuleARN": {
                return Optional.ofNullable(clazz.cast(this.ruleARN()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends XRayRequest.BuilderImpl
    implements Builder {
        private String ruleName;
        private String ruleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSamplingRuleRequest model) {
            super(model);
            this.ruleName(model.ruleName);
            this.ruleARN(model.ruleARN);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getRuleARN() {
            return this.ruleARN;
        }

        @Override
        public final Builder ruleARN(String ruleARN) {
            this.ruleARN = ruleARN;
            return this;
        }

        public final void setRuleARN(String ruleARN) {
            this.ruleARN = ruleARN;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSamplingRuleRequest build() {
            return new DeleteSamplingRuleRequest(this);
        }
    }

    public static interface Builder
    extends XRayRequest.Builder,
    CopyableBuilder<Builder, DeleteSamplingRuleRequest> {
        public Builder ruleName(String var1);

        public Builder ruleARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

