/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.AnnotationValue;

@SdkInternalApi
public class AnnotationValueMarshaller {
    private static final MarshallingInfo<Double> NUMBERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberValue").build();
    private static final MarshallingInfo<Boolean> BOOLEANVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BooleanValue").build();
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringValue").build();
    private static final AnnotationValueMarshaller instance = new AnnotationValueMarshaller();

    public static AnnotationValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(AnnotationValue annotationValue, ProtocolMarshaller protocolMarshaller) {
        if (annotationValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)annotationValue.numberValue(), NUMBERVALUE_BINDING);
            protocolMarshaller.marshall((Object)annotationValue.booleanValue(), BOOLEANVALUE_BINDING);
            protocolMarshaller.marshall((Object)annotationValue.stringValue(), STRINGVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

