/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.transform.HttpMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Http
implements StructuredPojo,
ToCopyableBuilder<Builder, Http> {
    private final String httpURL;
    private final Integer httpStatus;
    private final String httpMethod;
    private final String userAgent;
    private final String clientIp;

    private Http(BuilderImpl builder) {
        this.httpURL = builder.httpURL;
        this.httpStatus = builder.httpStatus;
        this.httpMethod = builder.httpMethod;
        this.userAgent = builder.userAgent;
        this.clientIp = builder.clientIp;
    }

    public String httpURL() {
        return this.httpURL;
    }

    public Integer httpStatus() {
        return this.httpStatus;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public String clientIp() {
        return this.clientIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.httpURL() == null ? 0 : this.httpURL().hashCode());
        hashCode = 31 * hashCode + (this.httpStatus() == null ? 0 : this.httpStatus().hashCode());
        hashCode = 31 * hashCode + (this.httpMethod() == null ? 0 : this.httpMethod().hashCode());
        hashCode = 31 * hashCode + (this.userAgent() == null ? 0 : this.userAgent().hashCode());
        hashCode = 31 * hashCode + (this.clientIp() == null ? 0 : this.clientIp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Http)) {
            return false;
        }
        Http other = (Http)obj;
        if (other.httpURL() == null ^ this.httpURL() == null) {
            return false;
        }
        if (other.httpURL() != null && !other.httpURL().equals(this.httpURL())) {
            return false;
        }
        if (other.httpStatus() == null ^ this.httpStatus() == null) {
            return false;
        }
        if (other.httpStatus() != null && !other.httpStatus().equals(this.httpStatus())) {
            return false;
        }
        if (other.httpMethod() == null ^ this.httpMethod() == null) {
            return false;
        }
        if (other.httpMethod() != null && !other.httpMethod().equals(this.httpMethod())) {
            return false;
        }
        if (other.userAgent() == null ^ this.userAgent() == null) {
            return false;
        }
        if (other.userAgent() != null && !other.userAgent().equals(this.userAgent())) {
            return false;
        }
        if (other.clientIp() == null ^ this.clientIp() == null) {
            return false;
        }
        return other.clientIp() == null || other.clientIp().equals(this.clientIp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.httpURL() != null) {
            sb.append("HttpURL: ").append(this.httpURL()).append(",");
        }
        if (this.httpStatus() != null) {
            sb.append("HttpStatus: ").append(this.httpStatus()).append(",");
        }
        if (this.httpMethod() != null) {
            sb.append("HttpMethod: ").append(this.httpMethod()).append(",");
        }
        if (this.userAgent() != null) {
            sb.append("UserAgent: ").append(this.userAgent()).append(",");
        }
        if (this.clientIp() != null) {
            sb.append("ClientIp: ").append(this.clientIp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HttpMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String httpURL;
        private Integer httpStatus;
        private String httpMethod;
        private String userAgent;
        private String clientIp;

        private BuilderImpl() {
        }

        private BuilderImpl(Http model) {
            this.setHttpURL(model.httpURL);
            this.setHttpStatus(model.httpStatus);
            this.setHttpMethod(model.httpMethod);
            this.setUserAgent(model.userAgent);
            this.setClientIp(model.clientIp);
        }

        public final String getHttpURL() {
            return this.httpURL;
        }

        @Override
        public final Builder httpURL(String httpURL) {
            this.httpURL = httpURL;
            return this;
        }

        public final void setHttpURL(String httpURL) {
            this.httpURL = httpURL;
        }

        public final Integer getHttpStatus() {
            return this.httpStatus;
        }

        @Override
        public final Builder httpStatus(Integer httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public final void setHttpStatus(Integer httpStatus) {
            this.httpStatus = httpStatus;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getUserAgent() {
            return this.userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public final String getClientIp() {
            return this.clientIp;
        }

        @Override
        public final Builder clientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        public final void setClientIp(String clientIp) {
            this.clientIp = clientIp;
        }

        public Http build() {
            return new Http(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Http> {
        public Builder httpURL(String var1);

        public Builder httpStatus(Integer var1);

        public Builder httpMethod(String var1);

        public Builder userAgent(String var1);

        public Builder clientIp(String var1);
    }
}

