/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.xray.model.Alias;
import software.amazon.awssdk.services.xray.model.AliasListCopier;
import software.amazon.awssdk.services.xray.model.EdgeStatistics;
import software.amazon.awssdk.services.xray.model.HistogramCopier;
import software.amazon.awssdk.services.xray.model.HistogramEntry;
import software.amazon.awssdk.services.xray.transform.EdgeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Edge
implements StructuredPojo,
ToCopyableBuilder<Builder, Edge> {
    private final Integer referenceId;
    private final Date startTime;
    private final Date endTime;
    private final EdgeStatistics summaryStatistics;
    private final List<HistogramEntry> responseTimeHistogram;
    private final List<Alias> aliases;

    private Edge(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.summaryStatistics = builder.summaryStatistics;
        this.responseTimeHistogram = builder.responseTimeHistogram;
        this.aliases = builder.aliases;
    }

    public Integer referenceId() {
        return this.referenceId;
    }

    public Date startTime() {
        return this.startTime;
    }

    public Date endTime() {
        return this.endTime;
    }

    public EdgeStatistics summaryStatistics() {
        return this.summaryStatistics;
    }

    public List<HistogramEntry> responseTimeHistogram() {
        return this.responseTimeHistogram;
    }

    public List<Alias> aliases() {
        return this.aliases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.referenceId() == null ? 0 : this.referenceId().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.summaryStatistics() == null ? 0 : this.summaryStatistics().hashCode());
        hashCode = 31 * hashCode + (this.responseTimeHistogram() == null ? 0 : this.responseTimeHistogram().hashCode());
        hashCode = 31 * hashCode + (this.aliases() == null ? 0 : this.aliases().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)obj;
        if (other.referenceId() == null ^ this.referenceId() == null) {
            return false;
        }
        if (other.referenceId() != null && !other.referenceId().equals(this.referenceId())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.summaryStatistics() == null ^ this.summaryStatistics() == null) {
            return false;
        }
        if (other.summaryStatistics() != null && !other.summaryStatistics().equals(this.summaryStatistics())) {
            return false;
        }
        if (other.responseTimeHistogram() == null ^ this.responseTimeHistogram() == null) {
            return false;
        }
        if (other.responseTimeHistogram() != null && !other.responseTimeHistogram().equals(this.responseTimeHistogram())) {
            return false;
        }
        if (other.aliases() == null ^ this.aliases() == null) {
            return false;
        }
        return other.aliases() == null || other.aliases().equals(this.aliases());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.referenceId() != null) {
            sb.append("ReferenceId: ").append(this.referenceId()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.summaryStatistics() != null) {
            sb.append("SummaryStatistics: ").append(this.summaryStatistics()).append(",");
        }
        if (this.responseTimeHistogram() != null) {
            sb.append("ResponseTimeHistogram: ").append(this.responseTimeHistogram()).append(",");
        }
        if (this.aliases() != null) {
            sb.append("Aliases: ").append(this.aliases()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EdgeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer referenceId;
        private Date startTime;
        private Date endTime;
        private EdgeStatistics summaryStatistics;
        private List<HistogramEntry> responseTimeHistogram;
        private List<Alias> aliases;

        private BuilderImpl() {
        }

        private BuilderImpl(Edge model) {
            this.setReferenceId(model.referenceId);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setSummaryStatistics(model.summaryStatistics);
            this.setResponseTimeHistogram(model.responseTimeHistogram);
            this.setAliases(model.aliases);
        }

        public final Integer getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(Integer referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(Integer referenceId) {
            this.referenceId = referenceId;
        }

        public final Date getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
        }

        public final Date getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
        }

        public final EdgeStatistics getSummaryStatistics() {
            return this.summaryStatistics;
        }

        @Override
        public final Builder summaryStatistics(EdgeStatistics summaryStatistics) {
            this.summaryStatistics = summaryStatistics;
            return this;
        }

        public final void setSummaryStatistics(EdgeStatistics summaryStatistics) {
            this.summaryStatistics = summaryStatistics;
        }

        public final Collection<HistogramEntry> getResponseTimeHistogram() {
            return this.responseTimeHistogram;
        }

        @Override
        public final Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copy(responseTimeHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(HistogramEntry ... responseTimeHistogram) {
            if (this.responseTimeHistogram == null) {
                this.responseTimeHistogram = new ArrayList<HistogramEntry>(responseTimeHistogram.length);
            }
            for (HistogramEntry e : responseTimeHistogram) {
                this.responseTimeHistogram.add(e);
            }
            return this;
        }

        public final void setResponseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copy(responseTimeHistogram);
        }

        @SafeVarargs
        public final void setResponseTimeHistogram(HistogramEntry ... responseTimeHistogram) {
            if (this.responseTimeHistogram == null) {
                this.responseTimeHistogram = new ArrayList<HistogramEntry>(responseTimeHistogram.length);
            }
            for (HistogramEntry e : responseTimeHistogram) {
                this.responseTimeHistogram.add(e);
            }
        }

        public final Collection<Alias> getAliases() {
            return this.aliases;
        }

        @Override
        public final Builder aliases(Collection<Alias> aliases) {
            this.aliases = AliasListCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Alias ... aliases) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<Alias>(aliases.length);
            }
            for (Alias e : aliases) {
                this.aliases.add(e);
            }
            return this;
        }

        public final void setAliases(Collection<Alias> aliases) {
            this.aliases = AliasListCopier.copy(aliases);
        }

        @SafeVarargs
        public final void setAliases(Alias ... aliases) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<Alias>(aliases.length);
            }
            for (Alias e : aliases) {
                this.aliases.add(e);
            }
        }

        public Edge build() {
            return new Edge(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Edge> {
        public Builder referenceId(Integer var1);

        public Builder startTime(Date var1);

        public Builder endTime(Date var1);

        public Builder summaryStatistics(EdgeStatistics var1);

        public Builder responseTimeHistogram(Collection<HistogramEntry> var1);

        public Builder responseTimeHistogram(HistogramEntry ... var1);

        public Builder aliases(Collection<Alias> var1);

        public Builder aliases(Alias ... var1);
    }
}

