/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WallpaperImageInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WallpaperImageInput> {
    private static final SdkField<SdkBytes> BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("blob").getter(WallpaperImageInput.getter(WallpaperImageInput::blob)).setter(WallpaperImageInput.setter(Builder::blob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blob").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Uri").getter(WallpaperImageInput.getter(WallpaperImageInput::s3Uri)).setter(WallpaperImageInput.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOB_FIELD, S3_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WallpaperImageInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes blob;
    private final String s3Uri;
    private final Type type;

    private WallpaperImageInput(BuilderImpl builder) {
        this.blob = builder.blob;
        this.s3Uri = builder.s3Uri;
        this.type = builder.type;
    }

    public final SdkBytes blob() {
        return this.blob;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blob());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WallpaperImageInput)) {
            return false;
        }
        WallpaperImageInput other = (WallpaperImageInput)obj;
        return Objects.equals(this.blob(), other.blob()) && Objects.equals(this.s3Uri(), other.s3Uri());
    }

    public final String toString() {
        return ToString.builder((String)"WallpaperImageInput").add("Blob", (Object)this.blob()).add("S3Uri", (Object)this.s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blob": {
                return Optional.ofNullable(clazz.cast(this.blob()));
            }
            case "s3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
        }
        return Optional.empty();
    }

    public static WallpaperImageInput fromBlob(SdkBytes blob) {
        return (WallpaperImageInput)WallpaperImageInput.builder().blob(blob).build();
    }

    public static WallpaperImageInput fromS3Uri(String s3Uri) {
        return (WallpaperImageInput)WallpaperImageInput.builder().s3Uri(s3Uri).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blob", BLOB_FIELD);
        map.put("s3Uri", S3_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WallpaperImageInput, T> g) {
        return obj -> g.apply((WallpaperImageInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BLOB,
        S3_URI,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes blob;
        private String s3Uri;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(WallpaperImageInput model) {
            this.blob(model.blob);
            this.s3Uri(model.s3Uri);
        }

        public final ByteBuffer getBlob() {
            return this.blob == null ? null : this.blob.asByteBuffer();
        }

        public final void setBlob(ByteBuffer blob) {
            this.blob(blob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)blob));
        }

        @Override
        public final Builder blob(SdkBytes blob) {
            SdkBytes oldValue = this.blob;
            this.blob = blob;
            this.handleUnionValueChange(Type.BLOB, oldValue, this.blob);
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            String oldValue = this.s3Uri;
            this.s3Uri = s3Uri;
            this.handleUnionValueChange(Type.S3_URI, oldValue, this.s3Uri);
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            String oldValue = this.s3Uri;
            this.s3Uri = s3Uri;
            this.handleUnionValueChange(Type.S3_URI, oldValue, this.s3Uri);
            return this;
        }

        public WallpaperImageInput build() {
            return new WallpaperImageInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WallpaperImageInput> {
        public Builder blob(SdkBytes var1);

        public Builder s3Uri(String var1);
    }
}

