/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ToolbarItem {
    WINDOWS("Windows"),
    DUAL_MONITOR("DualMonitor"),
    FULL_SCREEN("FullScreen"),
    WEBCAM("Webcam"),
    MICROPHONE("Microphone"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ToolbarItem> VALUE_MAP;
    private final String value;

    private ToolbarItem(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ToolbarItem fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ToolbarItem> knownValues() {
        EnumSet<ToolbarItem> knownValues = EnumSet.allOf(ToolbarItem.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ToolbarItem.class, ToolbarItem::toString);
    }
}

