/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Category {
    CULTS("Cults"),
    GAMBLING("Gambling"),
    NUDITY("Nudity"),
    PORNOGRAPHY("Pornography"),
    SEX_EDUCATION("SexEducation"),
    TASTELESS("Tasteless"),
    VIOLENCE("Violence"),
    DOWNLOAD_SITES("DownloadSites"),
    IMAGE_SHARING("ImageSharing"),
    PEER_TO_PEER("PeerToPeer"),
    STREAMING_MEDIA_AND_DOWNLOADS("StreamingMediaAndDownloads"),
    GENERATIVE_AI("GenerativeAI"),
    CRIMINAL_ACTIVITY("CriminalActivity"),
    HACKING("Hacking"),
    HATE_AND_INTOLERANCE("HateAndIntolerance"),
    ILLEGAL_DRUG("IllegalDrug"),
    ILLEGAL_SOFTWARE("IllegalSoftware"),
    SCHOOL_CHEATING("SchoolCheating"),
    SELF_HARM("SelfHarm"),
    WEAPONS("Weapons"),
    CHAT("Chat"),
    GAMES("Games"),
    INSTANT_MESSAGING("InstantMessaging"),
    PROFESSIONAL_NETWORK("ProfessionalNetwork"),
    SOCIAL_NETWORKING("SocialNetworking"),
    WEB_BASED_EMAIL("WebBasedEmail"),
    PARKED_DOMAINS("ParkedDomains"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Category> VALUE_MAP;
    private final String value;

    private Category(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Category fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Category> knownValues() {
        EnumSet<Category> knownValues = EnumSet.allOf(Category.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Category.class, Category::toString);
    }
}

