/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesweb.model.ColorTheme;
import software.amazon.awssdk.services.workspacesweb.model.IconImageInput;
import software.amazon.awssdk.services.workspacesweb.model.Locale;
import software.amazon.awssdk.services.workspacesweb.model.LocalizedBrandingStringMapCopier;
import software.amazon.awssdk.services.workspacesweb.model.LocalizedBrandingStrings;
import software.amazon.awssdk.services.workspacesweb.model.WallpaperImageInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrandingConfigurationUpdateInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrandingConfigurationUpdateInput> {
    private static final SdkField<IconImageInput> LOGO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logo").getter(BrandingConfigurationUpdateInput.getter(BrandingConfigurationUpdateInput::logo)).setter(BrandingConfigurationUpdateInput.setter(Builder::logo)).constructor(IconImageInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logo").build()}).build();
    private static final SdkField<WallpaperImageInput> WALLPAPER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("wallpaper").getter(BrandingConfigurationUpdateInput.getter(BrandingConfigurationUpdateInput::wallpaper)).setter(BrandingConfigurationUpdateInput.setter(Builder::wallpaper)).constructor(WallpaperImageInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wallpaper").build()}).build();
    private static final SdkField<IconImageInput> FAVICON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("favicon").getter(BrandingConfigurationUpdateInput.getter(BrandingConfigurationUpdateInput::favicon)).setter(BrandingConfigurationUpdateInput.setter(Builder::favicon)).constructor(IconImageInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("favicon").build()}).build();
    private static final SdkField<Map<String, LocalizedBrandingStrings>> LOCALIZED_STRINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("localizedStrings").getter(BrandingConfigurationUpdateInput.getter(BrandingConfigurationUpdateInput::localizedStringsAsStrings)).setter(BrandingConfigurationUpdateInput.setter(Builder::localizedStringsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localizedStrings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalizedBrandingStrings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> COLOR_THEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("colorTheme").getter(BrandingConfigurationUpdateInput.getter(BrandingConfigurationUpdateInput::colorThemeAsString)).setter(BrandingConfigurationUpdateInput.setter(Builder::colorTheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorTheme").build()}).build();
    private static final SdkField<String> TERMS_OF_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("termsOfService").getter(BrandingConfigurationUpdateInput.getter(BrandingConfigurationUpdateInput::termsOfService)).setter(BrandingConfigurationUpdateInput.setter(Builder::termsOfService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termsOfService").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGO_FIELD, WALLPAPER_FIELD, FAVICON_FIELD, LOCALIZED_STRINGS_FIELD, COLOR_THEME_FIELD, TERMS_OF_SERVICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BrandingConfigurationUpdateInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final IconImageInput logo;
    private final WallpaperImageInput wallpaper;
    private final IconImageInput favicon;
    private final Map<String, LocalizedBrandingStrings> localizedStrings;
    private final String colorTheme;
    private final String termsOfService;

    private BrandingConfigurationUpdateInput(BuilderImpl builder) {
        this.logo = builder.logo;
        this.wallpaper = builder.wallpaper;
        this.favicon = builder.favicon;
        this.localizedStrings = builder.localizedStrings;
        this.colorTheme = builder.colorTheme;
        this.termsOfService = builder.termsOfService;
    }

    public final IconImageInput logo() {
        return this.logo;
    }

    public final WallpaperImageInput wallpaper() {
        return this.wallpaper;
    }

    public final IconImageInput favicon() {
        return this.favicon;
    }

    public final Map<Locale, LocalizedBrandingStrings> localizedStrings() {
        return LocalizedBrandingStringMapCopier.copyStringToEnum(this.localizedStrings);
    }

    public final boolean hasLocalizedStrings() {
        return this.localizedStrings != null && !(this.localizedStrings instanceof SdkAutoConstructMap);
    }

    public final Map<String, LocalizedBrandingStrings> localizedStringsAsStrings() {
        return this.localizedStrings;
    }

    public final ColorTheme colorTheme() {
        return ColorTheme.fromValue(this.colorTheme);
    }

    public final String colorThemeAsString() {
        return this.colorTheme;
    }

    public final String termsOfService() {
        return this.termsOfService;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logo());
        hashCode = 31 * hashCode + Objects.hashCode(this.wallpaper());
        hashCode = 31 * hashCode + Objects.hashCode(this.favicon());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalizedStrings() ? this.localizedStringsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.colorThemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termsOfService());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrandingConfigurationUpdateInput)) {
            return false;
        }
        BrandingConfigurationUpdateInput other = (BrandingConfigurationUpdateInput)obj;
        return Objects.equals(this.logo(), other.logo()) && Objects.equals(this.wallpaper(), other.wallpaper()) && Objects.equals(this.favicon(), other.favicon()) && this.hasLocalizedStrings() == other.hasLocalizedStrings() && Objects.equals(this.localizedStringsAsStrings(), other.localizedStringsAsStrings()) && Objects.equals(this.colorThemeAsString(), other.colorThemeAsString()) && Objects.equals(this.termsOfService(), other.termsOfService());
    }

    public final String toString() {
        return ToString.builder((String)"BrandingConfigurationUpdateInput").add("Logo", (Object)this.logo()).add("Wallpaper", (Object)this.wallpaper()).add("Favicon", (Object)this.favicon()).add("LocalizedStrings", this.hasLocalizedStrings() ? this.localizedStringsAsStrings() : null).add("ColorTheme", (Object)this.colorThemeAsString()).add("TermsOfService", (Object)(this.termsOfService() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logo": {
                return Optional.ofNullable(clazz.cast(this.logo()));
            }
            case "wallpaper": {
                return Optional.ofNullable(clazz.cast(this.wallpaper()));
            }
            case "favicon": {
                return Optional.ofNullable(clazz.cast(this.favicon()));
            }
            case "localizedStrings": {
                return Optional.ofNullable(clazz.cast(this.localizedStringsAsStrings()));
            }
            case "colorTheme": {
                return Optional.ofNullable(clazz.cast(this.colorThemeAsString()));
            }
            case "termsOfService": {
                return Optional.ofNullable(clazz.cast(this.termsOfService()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logo", LOGO_FIELD);
        map.put("wallpaper", WALLPAPER_FIELD);
        map.put("favicon", FAVICON_FIELD);
        map.put("localizedStrings", LOCALIZED_STRINGS_FIELD);
        map.put("colorTheme", COLOR_THEME_FIELD);
        map.put("termsOfService", TERMS_OF_SERVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrandingConfigurationUpdateInput, T> g) {
        return obj -> g.apply((BrandingConfigurationUpdateInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private IconImageInput logo;
        private WallpaperImageInput wallpaper;
        private IconImageInput favicon;
        private Map<String, LocalizedBrandingStrings> localizedStrings = DefaultSdkAutoConstructMap.getInstance();
        private String colorTheme;
        private String termsOfService;

        private BuilderImpl() {
        }

        private BuilderImpl(BrandingConfigurationUpdateInput model) {
            this.logo(model.logo);
            this.wallpaper(model.wallpaper);
            this.favicon(model.favicon);
            this.localizedStringsWithStrings(model.localizedStrings);
            this.colorTheme(model.colorTheme);
            this.termsOfService(model.termsOfService);
        }

        public final IconImageInput.Builder getLogo() {
            return this.logo != null ? this.logo.toBuilder() : null;
        }

        public final void setLogo(IconImageInput.BuilderImpl logo) {
            this.logo = logo != null ? logo.build() : null;
        }

        @Override
        public final Builder logo(IconImageInput logo) {
            this.logo = logo;
            return this;
        }

        public final WallpaperImageInput.Builder getWallpaper() {
            return this.wallpaper != null ? this.wallpaper.toBuilder() : null;
        }

        public final void setWallpaper(WallpaperImageInput.BuilderImpl wallpaper) {
            this.wallpaper = wallpaper != null ? wallpaper.build() : null;
        }

        @Override
        public final Builder wallpaper(WallpaperImageInput wallpaper) {
            this.wallpaper = wallpaper;
            return this;
        }

        public final IconImageInput.Builder getFavicon() {
            return this.favicon != null ? this.favicon.toBuilder() : null;
        }

        public final void setFavicon(IconImageInput.BuilderImpl favicon) {
            this.favicon = favicon != null ? favicon.build() : null;
        }

        @Override
        public final Builder favicon(IconImageInput favicon) {
            this.favicon = favicon;
            return this;
        }

        public final Map<String, LocalizedBrandingStrings.Builder> getLocalizedStrings() {
            Map<String, LocalizedBrandingStrings.Builder> result = LocalizedBrandingStringMapCopier.copyToBuilder(this.localizedStrings);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLocalizedStrings(Map<String, LocalizedBrandingStrings.BuilderImpl> localizedStrings) {
            this.localizedStrings = LocalizedBrandingStringMapCopier.copyFromBuilder(localizedStrings);
        }

        @Override
        public final Builder localizedStringsWithStrings(Map<String, LocalizedBrandingStrings> localizedStrings) {
            this.localizedStrings = LocalizedBrandingStringMapCopier.copy(localizedStrings);
            return this;
        }

        @Override
        public final Builder localizedStrings(Map<Locale, LocalizedBrandingStrings> localizedStrings) {
            this.localizedStrings = LocalizedBrandingStringMapCopier.copyEnumToString(localizedStrings);
            return this;
        }

        public final String getColorTheme() {
            return this.colorTheme;
        }

        public final void setColorTheme(String colorTheme) {
            this.colorTheme = colorTheme;
        }

        @Override
        public final Builder colorTheme(String colorTheme) {
            this.colorTheme = colorTheme;
            return this;
        }

        @Override
        public final Builder colorTheme(ColorTheme colorTheme) {
            this.colorTheme(colorTheme == null ? null : colorTheme.toString());
            return this;
        }

        public final String getTermsOfService() {
            return this.termsOfService;
        }

        public final void setTermsOfService(String termsOfService) {
            this.termsOfService = termsOfService;
        }

        @Override
        public final Builder termsOfService(String termsOfService) {
            this.termsOfService = termsOfService;
            return this;
        }

        public BrandingConfigurationUpdateInput build() {
            return new BrandingConfigurationUpdateInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrandingConfigurationUpdateInput> {
        public Builder logo(IconImageInput var1);

        default public Builder logo(Consumer<IconImageInput.Builder> logo) {
            return this.logo((IconImageInput)((IconImageInput.Builder)IconImageInput.builder().applyMutation(logo)).build());
        }

        public Builder wallpaper(WallpaperImageInput var1);

        default public Builder wallpaper(Consumer<WallpaperImageInput.Builder> wallpaper) {
            return this.wallpaper((WallpaperImageInput)((WallpaperImageInput.Builder)WallpaperImageInput.builder().applyMutation(wallpaper)).build());
        }

        public Builder favicon(IconImageInput var1);

        default public Builder favicon(Consumer<IconImageInput.Builder> favicon) {
            return this.favicon((IconImageInput)((IconImageInput.Builder)IconImageInput.builder().applyMutation(favicon)).build());
        }

        public Builder localizedStringsWithStrings(Map<String, LocalizedBrandingStrings> var1);

        public Builder localizedStrings(Map<Locale, LocalizedBrandingStrings> var1);

        public Builder colorTheme(String var1);

        public Builder colorTheme(ColorTheme var1);

        public Builder termsOfService(String var1);
    }
}

