/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesweb.model.ArnListCopier;
import software.amazon.awssdk.services.workspacesweb.model.EncryptionContextMapCopier;
import software.amazon.awssdk.services.workspacesweb.model.EventFilter;
import software.amazon.awssdk.services.workspacesweb.model.LogConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionLogger
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionLogger> {
    private static final SdkField<String> SESSION_LOGGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionLoggerArn").getter(SessionLogger.getter(SessionLogger::sessionLoggerArn)).setter(SessionLogger.setter(Builder::sessionLoggerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionLoggerArn").build()}).build();
    private static final SdkField<EventFilter> EVENT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventFilter").getter(SessionLogger.getter(SessionLogger::eventFilter)).setter(SessionLogger.setter(Builder::eventFilter)).constructor(EventFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventFilter").build()}).build();
    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfiguration").getter(SessionLogger.getter(SessionLogger::logConfiguration)).setter(SessionLogger.setter(Builder::logConfiguration)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()}).build();
    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerManagedKey").getter(SessionLogger.getter(SessionLogger::customerManagedKey)).setter(SessionLogger.setter(Builder::customerManagedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalEncryptionContext").getter(SessionLogger.getter(SessionLogger::additionalEncryptionContext)).setter(SessionLogger.setter(Builder::additionalEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedPortalArns").getter(SessionLogger.getter(SessionLogger::associatedPortalArns)).setter(SessionLogger.setter(Builder::associatedPortalArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(SessionLogger.getter(SessionLogger::displayName)).setter(SessionLogger.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(SessionLogger.getter(SessionLogger::creationDate)).setter(SessionLogger.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_LOGGER_ARN_FIELD, EVENT_FILTER_FIELD, LOG_CONFIGURATION_FIELD, CUSTOMER_MANAGED_KEY_FIELD, ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, ASSOCIATED_PORTAL_ARNS_FIELD, DISPLAY_NAME_FIELD, CREATION_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SessionLogger.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sessionLoggerArn;
    private final EventFilter eventFilter;
    private final LogConfiguration logConfiguration;
    private final String customerManagedKey;
    private final Map<String, String> additionalEncryptionContext;
    private final List<String> associatedPortalArns;
    private final String displayName;
    private final Instant creationDate;

    private SessionLogger(BuilderImpl builder) {
        this.sessionLoggerArn = builder.sessionLoggerArn;
        this.eventFilter = builder.eventFilter;
        this.logConfiguration = builder.logConfiguration;
        this.customerManagedKey = builder.customerManagedKey;
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.associatedPortalArns = builder.associatedPortalArns;
        this.displayName = builder.displayName;
        this.creationDate = builder.creationDate;
    }

    public final String sessionLoggerArn() {
        return this.sessionLoggerArn;
    }

    public final EventFilter eventFilter() {
        return this.eventFilter;
    }

    public final LogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final String customerManagedKey() {
        return this.customerManagedKey;
    }

    public final boolean hasAdditionalEncryptionContext() {
        return this.additionalEncryptionContext != null && !(this.additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public final boolean hasAssociatedPortalArns() {
        return this.associatedPortalArns != null && !(this.associatedPortalArns instanceof SdkAutoConstructList);
    }

    public final List<String> associatedPortalArns() {
        return this.associatedPortalArns;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionLoggerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionLogger)) {
            return false;
        }
        SessionLogger other = (SessionLogger)obj;
        return Objects.equals(this.sessionLoggerArn(), other.sessionLoggerArn()) && Objects.equals(this.eventFilter(), other.eventFilter()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && Objects.equals(this.customerManagedKey(), other.customerManagedKey()) && this.hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext() && Objects.equals(this.additionalEncryptionContext(), other.additionalEncryptionContext()) && this.hasAssociatedPortalArns() == other.hasAssociatedPortalArns() && Objects.equals(this.associatedPortalArns(), other.associatedPortalArns()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public final String toString() {
        return ToString.builder((String)"SessionLogger").add("SessionLoggerArn", (Object)this.sessionLoggerArn()).add("EventFilter", (Object)this.eventFilter()).add("LogConfiguration", (Object)this.logConfiguration()).add("CustomerManagedKey", (Object)this.customerManagedKey()).add("AdditionalEncryptionContext", this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null).add("AssociatedPortalArns", this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("CreationDate", (Object)this.creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionLoggerArn": {
                return Optional.ofNullable(clazz.cast(this.sessionLoggerArn()));
            }
            case "eventFilter": {
                return Optional.ofNullable(clazz.cast(this.eventFilter()));
            }
            case "logConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "customerManagedKey": {
                return Optional.ofNullable(clazz.cast(this.customerManagedKey()));
            }
            case "additionalEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.additionalEncryptionContext()));
            }
            case "associatedPortalArns": {
                return Optional.ofNullable(clazz.cast(this.associatedPortalArns()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionLoggerArn", SESSION_LOGGER_ARN_FIELD);
        map.put("eventFilter", EVENT_FILTER_FIELD);
        map.put("logConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("customerManagedKey", CUSTOMER_MANAGED_KEY_FIELD);
        map.put("additionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
        map.put("associatedPortalArns", ASSOCIATED_PORTAL_ARNS_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionLogger, T> g) {
        return obj -> g.apply((SessionLogger)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionLoggerArn;
        private EventFilter eventFilter;
        private LogConfiguration logConfiguration;
        private String customerManagedKey;
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();
        private String displayName;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionLogger model) {
            this.sessionLoggerArn(model.sessionLoggerArn);
            this.eventFilter(model.eventFilter);
            this.logConfiguration(model.logConfiguration);
            this.customerManagedKey(model.customerManagedKey);
            this.additionalEncryptionContext(model.additionalEncryptionContext);
            this.associatedPortalArns(model.associatedPortalArns);
            this.displayName(model.displayName);
            this.creationDate(model.creationDate);
        }

        public final String getSessionLoggerArn() {
            return this.sessionLoggerArn;
        }

        public final void setSessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
        }

        @Override
        public final Builder sessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
            return this;
        }

        public final EventFilter.Builder getEventFilter() {
            return this.eventFilter != null ? this.eventFilter.toBuilder() : null;
        }

        public final void setEventFilter(EventFilter.BuilderImpl eventFilter) {
            this.eventFilter = eventFilter != null ? eventFilter.build() : null;
        }

        @Override
        public final Builder eventFilter(EventFilter eventFilter) {
            this.eventFilter = eventFilter;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final String getCustomerManagedKey() {
            return this.customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (this.additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (this.associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String ... associatedPortalArns) {
            this.associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public SessionLogger build() {
            return new SessionLogger(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionLogger> {
        public Builder sessionLoggerArn(String var1);

        public Builder eventFilter(EventFilter var1);

        default public Builder eventFilter(Consumer<EventFilter.Builder> eventFilter) {
            return this.eventFilter((EventFilter)((EventFilter.Builder)EventFilter.builder().applyMutation(eventFilter)).build());
        }

        public Builder logConfiguration(LogConfiguration var1);

        default public Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder customerManagedKey(String var1);

        public Builder additionalEncryptionContext(Map<String, String> var1);

        public Builder associatedPortalArns(Collection<String> var1);

        public Builder associatedPortalArns(String ... var1);

        public Builder displayName(String var1);

        public Builder creationDate(Instant var1);
    }
}

